package org.seasar.webwork;

import com.opensymphony.xwork.ObjectFactory;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import junit.framework.TestCase;
import org.seasar.extension.mock.servlet.MockServletConfig;
import org.seasar.framework.container.servlet.S2ContainerServlet;

public class S2ObjectFactoryServletTest extends TestCase {

    public void testInit() throws ServletException {
	ServletConfig containerServletConfig = new MockServletConfig();
	Servlet containerServlet = new S2ContainerServlet();
	containerServlet.init(containerServletConfig);

	ServletConfig objectFactoryServletConfig = new MockServletConfig();
	Servlet objectFactoryServlet = new S2ObjectFactoryServlet();
	objectFactoryServlet.init(objectFactoryServletConfig);

	ObjectFactory objectFactory = ObjectFactory.getObjectFactory();
	assertTrue(objectFactory instanceof S2ObjectFactory);
    }
}
