package org.seasar.webwork;

import com.opensymphony.xwork.ObjectFactory;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.impl.ComponentDefImpl;

public class S2ObjectFactory extends ObjectFactory {
    protected final S2Container container;

    protected S2ObjectFactory(S2Container container) {
	this.container = container;
    }

    public Object buildBean(Class clazz) throws Exception {
	Object bean;
	if (container.hasComponentDef(clazz)) {
	    bean = container.getComponent(clazz);
	} else {
	    ComponentDef componentDef = new ComponentDefImpl(clazz);
	    componentDef.setContainer(container);
	    bean = componentDef.getComponent();
	}
	return bean;
    }

    public Object buildBean(String className) throws Exception {
	Class clazz = getClassInstance(className);
	return buildBean(clazz);
    }
}
