package org.seasar.webwork;

import com.opensymphony.xwork.ObjectFactory;
import junit.framework.TestCase;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ContainerConstants;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;

public class S2ObjectFactoryTest extends TestCase {
    private S2Container container;
    private ObjectFactory objectFactory;

    public void setUp() {
	container = new S2ContainerImpl();
	objectFactory = new S2ObjectFactory(container);
    }

    public void testBuildRegisteredBeanByClass() throws Exception {
	registerTestService();
	registerTestAction();

	Object bean = objectFactory.buildBean(TestAction.class);
	assertTrue(bean instanceof TestAction);
    }

    public void testBuildNonRegisteredBeanByClass() throws Exception {
	registerTestService();

	Object bean = objectFactory.buildBean(TestAction.class);
	assertTrue(bean instanceof TestAction);
	assertEquals(1, container.getComponentDefSize());
    }

    public void testBuildRegisteredBeanByClassName() throws Exception {
	registerTestService();
	registerTestAction();

	Object bean = objectFactory.buildBean("org.seasar.webwork.S2ObjectFactoryTest$TestAction");
	assertTrue(bean instanceof TestAction);
    }

    public void testBuildNonRegisteredBeanByClassName() throws Exception {
	registerTestService();

	Object bean = objectFactory.buildBean("org.seasar.webwork.S2ObjectFactoryTest$TestAction");
	assertTrue(bean instanceof TestAction);
	assertEquals(1, container.getComponentDefSize());
    }

    private void registerTestService() {
	container.register(TestServiceImpl.class);
    }

    private void registerTestAction() {
	ComponentDef componentDef = new ComponentDefImpl(TestAction.class);
	componentDef.setInstanceMode(ContainerConstants.INSTANCE_PROTOTYPE);
	container.register(componentDef);
    }

    public static class TestAction {
	public TestAction(TestService testService) {
	}
    }

    public static interface TestService {
    }

    public static class TestServiceImpl implements TestService {
    }
}
