/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.types;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.seasar.extension.jdbc.types.AbstractValueType;
import org.seasar.framework.util.LongConversionUtil;

public class LongType
extends AbstractValueType {
    public LongType() {
        super(-5);
    }

    public Object getValue(ResultSet resultSet, int index) throws SQLException {
        return LongConversionUtil.toLong((Object)resultSet.getObject(index));
    }

    public Object getValue(ResultSet resultSet, String columnName) throws SQLException {
        return LongConversionUtil.toLong((Object)resultSet.getObject(columnName));
    }

    public Object getValue(CallableStatement cs, int index) throws SQLException {
        return LongConversionUtil.toLong((Object)cs.getObject(index));
    }

    public Object getValue(CallableStatement cs, String parameterName) throws SQLException {
        return LongConversionUtil.toLong((Object)cs.getObject(parameterName));
    }

    public void bindValue(PreparedStatement ps, int index, Object value) throws SQLException {
        if (value == null) {
            this.setNull(ps, index);
        } else {
            ps.setLong(index, LongConversionUtil.toPrimitiveLong((Object)value));
        }
    }

    public void bindValue(CallableStatement cs, String parameterName, Object value) throws SQLException {
        if (value == null) {
            this.setNull(cs, parameterName);
        } else {
            cs.setLong(parameterName, LongConversionUtil.toPrimitiveLong((Object)value));
        }
    }
}

