/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.mock.servlet;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionContext;
import org.seasar.framework.mock.servlet.MockHttpSession;
import org.seasar.framework.util.EnumerationAdapter;

public class MockHttpSessionImpl
implements MockHttpSession,
Serializable {
    private static final long serialVersionUID = 2182279632419560836L;
    private final long creationTime;
    private long lastAccessedTime;
    private ServletContext servletContext;
    private String id;
    private boolean new_;
    private boolean valid;
    private int maxInactiveInterval;
    private Map attributes;

    public MockHttpSessionImpl(ServletContext servletContext) {
        this.lastAccessedTime = this.creationTime = System.currentTimeMillis();
        this.new_ = true;
        this.valid = true;
        this.maxInactiveInterval = -1;
        this.attributes = new HashMap();
        this.servletContext = servletContext;
        this.id = "id/" + this.hashCode();
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void access() {
        this.new_ = false;
        this.lastAccessedTime = System.currentTimeMillis();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public HttpSessionContext getSessionContext() {
        return null;
    }

    public Object getValue(String name) {
        return this.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return new EnumerationAdapter(this.attributes.keySet().iterator());
    }

    public String[] getValueNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public void putValue(String name, Object value) {
        this.setAttribute(name, value);
    }

    public void removeValue(String name) {
        this.removeAttribute(name);
    }

    public void invalidate() {
        if (!this.valid) {
            return;
        }
        this.attributes.clear();
        this.valid = false;
    }

    public boolean isNew() {
        return this.new_;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }
}

