/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.internal.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seasar.cubby.internal.util.LogMessages;
import org.seasar.cubby.internal.util.ServiceLoadingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceLoader<S>
implements Iterable<S> {
    private static final Logger logger = LoggerFactory.getLogger(ServiceLoader.class);
    private static final String PREFIX = "META-INF/services/";
    private final Map<String, S> providers = new LinkedHashMap<String, S>();
    private final Class<S> service;
    private final ClassLoader classLoader;

    private ServiceLoader(Class<S> service, ClassLoader classLoader) {
        this.service = service;
        this.classLoader = classLoader;
        this.reload();
    }

    public void reload() {
        this.providers.clear();
        String resourceName = PREFIX + this.service.getName();
        try {
            Enumeration<URL> urls = this.classLoader.getResources(resourceName);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                for (String providerClassName : this.parse(url)) {
                    this.providers.put(providerClassName, null);
                }
            }
        }
        catch (IOException e) {
            throw new ServiceLoadingException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> parse(URL url) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug(LogMessages.format("DCUB0017", this.service, url));
        }
        ArrayList<String> providerClassNames = new ArrayList<String>();
        InputStream input = null;
        BufferedReader reader = null;
        try {
            String line;
            input = url.openStream();
            reader = new BufferedReader(new InputStreamReader(input, "utf-8"));
            while ((line = reader.readLine()) != null) {
                String providerClassName = this.cleanup(line);
                if (providerClassName == null) continue;
                providerClassNames.add(providerClassName);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (input != null) {
                input.close();
            }
        }
        return providerClassNames;
    }

    private String cleanup(String line) {
        int commentIndex = line.indexOf(35);
        if (commentIndex >= 0) {
            line = line.substring(0, commentIndex);
        }
        if ((line = line.trim()).length() == 0) {
            return null;
        }
        return line;
    }

    @Override
    public Iterator<S> iterator() {
        return new ProviderIterator();
    }

    public static <S> ServiceLoader<S> load(Class<S> service, ClassLoader classLoader) {
        return new ServiceLoader<S>(service, classLoader);
    }

    public static <S> ServiceLoader<S> load(Class<S> service) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return ServiceLoader.load(service, classLoader);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProviderIterator
    implements Iterator<S> {
        private final Iterator<Map.Entry<String, S>> providerIterator;

        ProviderIterator() {
            this.providerIterator = ServiceLoader.this.providers.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.providerIterator.hasNext();
        }

        @Override
        public S next() {
            Map.Entry entry = this.providerIterator.next();
            if (entry.getValue() == null) {
                String providerClassName = entry.getKey();
                Object provider = this.newInstance(providerClassName);
                entry.setValue(provider);
                if (logger.isDebugEnabled()) {
                    logger.debug(LogMessages.format("DCUB0018", ServiceLoader.this.service, providerClassName, provider));
                }
            }
            return entry.getValue();
        }

        private S newInstance(String className) {
            try {
                Class<?> providerClass = Class.forName(className, true, ServiceLoader.this.classLoader);
                Object providerInstance = providerClass.newInstance();
                Object provider = ServiceLoader.this.service.cast(providerInstance);
                return provider;
            }
            catch (ClassNotFoundException e) {
                throw new ServiceLoadingException(e);
            }
            catch (InstantiationException e) {
                throw new ServiceLoadingException(e);
            }
            catch (IllegalAccessException e) {
                throw new ServiceLoadingException(e);
            }
            catch (ClassCastException e) {
                throw new ServiceLoadingException(e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

