/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.internal.controller.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import org.seasar.cubby.action.RequestParameter;
import org.seasar.cubby.controller.FormWrapper;
import org.seasar.cubby.controller.FormWrapperFactory;
import org.seasar.cubby.converter.ConversionHelper;
import org.seasar.cubby.converter.Converter;
import org.seasar.cubby.converter.impl.ConversionHelperImpl;
import org.seasar.cubby.spi.ConverterProvider;
import org.seasar.cubby.spi.ProviderFactory;
import org.seasar.cubby.spi.beans.Attribute;
import org.seasar.cubby.spi.beans.BeanDesc;
import org.seasar.cubby.spi.beans.BeanDescFactory;

public class FormWrapperFactoryImpl
implements FormWrapperFactory {
    private final ConversionHelper conversionHelper = new ConversionHelperImpl();

    public FormWrapper create(Object form) {
        FormWrapperImpl formObject = new FormWrapperImpl(form);
        return formObject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FormWrapperImpl
    implements FormWrapper {
        private final Object form;

        private FormWrapperImpl(Object form) {
            this.form = form;
        }

        @Override
        public boolean hasValues(String name) {
            if (this.form == null) {
                return false;
            }
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(this.form.getClass());
            Attribute attribute = this.findAttribute(beanDesc, name);
            return attribute != null;
        }

        @Override
        public String[] getValues(String name) {
            RequestParameter requestParameter;
            if (this.form == null) {
                return null;
            }
            BeanDesc beanDesc = BeanDescFactory.getBeanDesc(this.form.getClass());
            Attribute attribute = this.findAttribute(beanDesc, name);
            if (attribute == null) {
                return null;
            }
            Object value = attribute.getValue(this.form);
            if (value == null) {
                return null;
            }
            if (value instanceof String[]) {
                return (String[])value;
            }
            Class<? extends Converter> converterType = attribute.isAnnotationPresent(RequestParameter.class) ? (Converter.class.equals((requestParameter = attribute.getAnnotation(RequestParameter.class)).converter()) ? null : requestParameter.converter()) : null;
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                String[] array = (String[])Array.newInstance(String.class, length);
                for (int i = 0; i < length; ++i) {
                    Object element = Array.get(value, i);
                    String converted = this.convert(element, converterType);
                    Array.set(array, i, converted);
                }
                return array;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                String[] array = (String[])Array.newInstance(String.class, collection.size());
                int i = 0;
                for (Object element : collection) {
                    String converted = this.convert(element, converterType);
                    Array.set(array, i++, converted);
                }
                return array;
            }
            String[] array = (String[])Array.newInstance(String.class, 1);
            String converted = this.convert(value, converterType);
            Array.set(array, 0, converted);
            return array;
        }

        private Attribute findAttribute(BeanDesc beanDesc, String name) {
            for (Attribute attribute : beanDesc.findAllAttributes()) {
                RequestParameter requestParameter;
                String parameterName;
                if (!(attribute.isAnnotationPresent(RequestParameter.class) ? ((parameterName = (requestParameter = attribute.getAnnotation(RequestParameter.class)).name()) == null || parameterName.length() == 0 ? name.equals(attribute.getName()) : name.equals(parameterName)) : name.equals(attribute.getName()))) continue;
                return attribute;
            }
            return null;
        }

        private String convert(Object value, Class<? extends Converter> converterType) {
            if (value == null) {
                return null;
            }
            ConverterProvider converterProvider = ProviderFactory.get(ConverterProvider.class);
            Converter converter = converterType == null ? converterProvider.getConverter(null, value.getClass()) : converterProvider.getConverter(converterType);
            if (converter == null) {
                return value.toString();
            }
            return converter.convertToString(value, FormWrapperFactoryImpl.this.conversionHelper);
        }
    }
}

