/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.seasar.framework.exception.IllegalAccessRuntimeException;
import org.seasar.framework.exception.InvocationTargetRuntimeException;

public class MethodUtil {
    private static final Method IS_BRIDGE_METHOD = MethodUtil.getIsBridgeMethod();
    private static final Method IS_SYNTHETIC_METHOD = MethodUtil.getIsSyntheticMethod();
    protected static final String REFLECTION_UTIL_CLASS_NAME = "org.seasar.framework.util.tiger.ReflectionUtil";
    protected static final Method GET_ELEMENT_TYPE_OF_COLLECTION_FROM_PARAMETER_METHOD = MethodUtil.getElementTypeFromParameterMethod("Collection");
    protected static final Method GET_ELEMENT_TYPE_OF_COLLECTION_FROM_RETURN_METHOD = MethodUtil.getElementTypeFromReturnMethod("Collection");
    protected static final Method GET_ELEMENT_TYPE_OF_LIST_FROM_PARAMETER_METHOD = MethodUtil.getElementTypeFromParameterMethod("List");
    protected static final Method GET_ELEMENT_TYPE_OF_LIST_FROM_RETURN_METHOD = MethodUtil.getElementTypeFromReturnMethod("List");
    protected static final Method GET_ELEMENT_TYPE_OF_SET_FROM_PARAMETER_METHOD = MethodUtil.getElementTypeFromParameterMethod("Set");
    protected static final Method GET_ELEMENT_TYPE_OF_SET_FROM_RETURN_METHOD = MethodUtil.getElementTypeFromReturnMethod("Set");

    protected MethodUtil() {
    }

    public static Object invoke(Method method, Object target, Object[] args) throws InvocationTargetRuntimeException, IllegalAccessRuntimeException {
        try {
            return method.invoke(target, args);
        }
        catch (InvocationTargetException ex) {
            Throwable t = ex.getCause();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new InvocationTargetRuntimeException(method.getDeclaringClass(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessRuntimeException(method.getDeclaringClass(), ex);
        }
    }

    public static boolean isAbstract(Method method) {
        int mod = method.getModifiers();
        return Modifier.isAbstract(mod);
    }

    public static String getSignature(String methodName, Class[] argTypes) {
        StringBuffer buf = new StringBuffer(100);
        buf.append(methodName);
        buf.append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(argTypes[i].getName());
            }
        }
        buf.append(")");
        return buf.toString();
    }

    public static String getSignature(String methodName, Object[] methodArgs) {
        StringBuffer buf = new StringBuffer(100);
        buf.append(methodName);
        buf.append("(");
        if (methodArgs != null) {
            for (int i = 0; i < methodArgs.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                if (methodArgs[i] != null) {
                    buf.append(methodArgs[i].getClass().getName());
                    continue;
                }
                buf.append("null");
            }
        }
        buf.append(")");
        return buf.toString();
    }

    public static boolean isEqualsMethod(Method method) {
        return method != null && method.getName().equals("equals") && method.getReturnType() == Boolean.TYPE && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && method.getName().equals("hashCode") && method.getReturnType() == Integer.TYPE && method.getParameterTypes().length == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && method.getName().equals("toString") && method.getReturnType() == String.class && method.getParameterTypes().length == 0;
    }

    public static boolean isBridgeMethod(Method method) {
        if (IS_BRIDGE_METHOD == null) {
            return false;
        }
        return (Boolean)MethodUtil.invoke(IS_BRIDGE_METHOD, method, null);
    }

    public static boolean isSyntheticMethod(Method method) {
        if (IS_SYNTHETIC_METHOD == null) {
            return false;
        }
        return (Boolean)MethodUtil.invoke(IS_SYNTHETIC_METHOD, method, null);
    }

    private static Method getIsBridgeMethod() {
        try {
            return Method.class.getMethod("isBridge", null);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Method getIsSyntheticMethod() {
        try {
            return Method.class.getMethod("isSynthetic", null);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static Class getElementTypeOfCollectionFromParameterType(Method method, int position) {
        if (GET_ELEMENT_TYPE_OF_COLLECTION_FROM_PARAMETER_METHOD == null) {
            return null;
        }
        return (Class)MethodUtil.invoke(GET_ELEMENT_TYPE_OF_COLLECTION_FROM_PARAMETER_METHOD, null, new Object[]{method, new Integer(position)});
    }

    public static Class getElementTypeOfCollectionFromReturnType(Method method) {
        if (GET_ELEMENT_TYPE_OF_COLLECTION_FROM_RETURN_METHOD == null) {
            return null;
        }
        return (Class)MethodUtil.invoke(GET_ELEMENT_TYPE_OF_COLLECTION_FROM_RETURN_METHOD, null, new Object[]{method});
    }

    public static Class getElementTypeOfListFromParameterType(Method method, int position) {
        if (GET_ELEMENT_TYPE_OF_LIST_FROM_PARAMETER_METHOD == null) {
            return null;
        }
        return (Class)MethodUtil.invoke(GET_ELEMENT_TYPE_OF_LIST_FROM_PARAMETER_METHOD, null, new Object[]{method, new Integer(position)});
    }

    public static Class getElementTypeOfListFromReturnType(Method method) {
        if (GET_ELEMENT_TYPE_OF_LIST_FROM_RETURN_METHOD == null) {
            return null;
        }
        return (Class)MethodUtil.invoke(GET_ELEMENT_TYPE_OF_LIST_FROM_RETURN_METHOD, null, new Object[]{method});
    }

    public static Class getElementTypeOfSetFromParameterType(Method method, int position) {
        if (GET_ELEMENT_TYPE_OF_SET_FROM_PARAMETER_METHOD == null) {
            return null;
        }
        return (Class)MethodUtil.invoke(GET_ELEMENT_TYPE_OF_SET_FROM_PARAMETER_METHOD, null, new Object[]{method, new Integer(position)});
    }

    public static Class getElementTypeOfSetFromReturnType(Method method) {
        if (GET_ELEMENT_TYPE_OF_SET_FROM_RETURN_METHOD == null) {
            return null;
        }
        return (Class)MethodUtil.invoke(GET_ELEMENT_TYPE_OF_SET_FROM_RETURN_METHOD, null, new Object[]{method});
    }

    protected static Method getElementTypeFromParameterMethod(String type) {
        try {
            Class<?> reflectionUtilClass = Class.forName(REFLECTION_UTIL_CLASS_NAME);
            return reflectionUtilClass.getMethod("getElementTypeOf" + type + "FromParameterType", Method.class, Integer.TYPE);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected static Method getElementTypeFromReturnMethod(String type) {
        try {
            Class<?> reflectionUtilClass = Class.forName(REFLECTION_UTIL_CLASS_NAME);
            return reflectionUtilClass.getMethod("getElementTypeOf" + type + "FromReturnType", Method.class);
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

