/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.ResourceUtil;

public class MimeTypeUtil {
    protected MimeTypeUtil() {
    }

    public static String guessContentType(String path) {
        AssertionUtil.assertNotNull("path is null.", path);
        InputStream is = ResourceUtil.getResourceAsStream(path);
        String mimetype = null;
        try {
            mimetype = URLConnection.guessContentTypeFromStream(is);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        if (mimetype == null) {
            mimetype = URLConnection.guessContentTypeFromName(path);
        }
        return mimetype;
    }
}

