/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.seasar.extension.filter.util.RequestDumpUtil;
import org.seasar.framework.util.BooleanConversionUtil;

public class RequestDumpFilter
implements Filter {
    private static final Log log = LogFactory.getLog((Class)RequestDumpFilter.class);
    private FilterConfig config = null;
    private boolean beforeRequestParameter;
    private boolean afterRequestParameter;
    private boolean beforeRequestAttribute;
    private boolean afterRequestAttribute;
    private boolean beforeCookies;
    private boolean afterCookies;
    private boolean beforeRequestHeader;
    private boolean afterRequestHeader;
    private boolean beforeSessionAttribute;
    private boolean afterSessionAttribute;
    private boolean beforeContextAttribute;
    private boolean afterContextAttribute;
    private boolean afterResponse;
    private static final String INDENT = "  ";
    private static final String LF = System.getProperty("line.separator");

    public void init(FilterConfig filterConfig) throws ServletException {
        this.config = filterConfig;
        this.beforeRequestParameter = this.getBooleanParameter(filterConfig, "beforeRequestParameter", true);
        this.afterRequestParameter = this.getBooleanParameter(filterConfig, "afterRequestParameter", false);
        this.beforeRequestAttribute = this.getBooleanParameter(filterConfig, "beforeRequestAttribute", true);
        this.afterRequestAttribute = this.getBooleanParameter(filterConfig, "afterRequestAttribute", true);
        this.beforeRequestHeader = this.getBooleanParameter(filterConfig, "beforeRequestHeader", true);
        this.afterRequestHeader = this.getBooleanParameter(filterConfig, "afterRequestHeader", false);
        this.beforeContextAttribute = this.getBooleanParameter(filterConfig, "beforeContextAttribute", true);
        this.afterContextAttribute = this.getBooleanParameter(filterConfig, "afterContextAttribute", true);
        this.beforeCookies = this.getBooleanParameter(filterConfig, "beforeCookies", true);
        this.afterCookies = this.getBooleanParameter(filterConfig, "afterCookies", true);
        this.beforeSessionAttribute = this.getBooleanParameter(filterConfig, "beforeSessionAttribute", true);
        this.afterSessionAttribute = this.getBooleanParameter(filterConfig, "afterSessionAttribute", true);
        this.afterResponse = this.getBooleanParameter(filterConfig, "afterResponse", true);
        StringBuffer sb = new StringBuffer();
        RequestDumpUtil.dumpContextProperties(sb, filterConfig.getServletContext(), LF, INDENT);
        log.debug((Object)sb.toString());
    }

    public void destroy() {
        this.config = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.config == null) {
            return;
        }
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest hrequest = (HttpServletRequest)request;
        HttpServletResponse hresponse = (HttpServletResponse)response;
        this.dumpBefore(hrequest);
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.dumpAfter(hrequest, hresponse);
        }
    }

    private void dumpBefore(HttpServletRequest request) {
        ServletContext context = this.config.getServletContext();
        StringBuffer sb = new StringBuffer();
        sb.append(LF);
        sb.append(LF);
        sb.append("** before *****************************************: ");
        sb.append(this.getServletPath((ServletRequest)request));
        sb.append(LF);
        RequestDumpUtil.dumpRequestProperties(sb, request, LF, INDENT);
        RequestDumpUtil.dumpSessionProperties(sb, request, LF, INDENT);
        if (this.beforeRequestParameter) {
            RequestDumpUtil.dumpRequestParameters(sb, request, LF, INDENT);
        }
        if (this.beforeRequestAttribute) {
            RequestDumpUtil.dumpRequestAttributes(sb, request, LF, INDENT);
        }
        if (this.beforeCookies) {
            RequestDumpUtil.dumpCookies(sb, request, LF, INDENT);
        }
        if (this.beforeRequestHeader) {
            RequestDumpUtil.dumpRequestHeaders(sb, request, LF, INDENT);
        }
        if (this.beforeSessionAttribute) {
            RequestDumpUtil.dumpSessionAttributes(sb, request, LF, INDENT);
        }
        if (this.beforeContextAttribute) {
            RequestDumpUtil.dumpContextAttributes(sb, context, LF, INDENT);
        }
        log.debug((Object)sb.toString());
    }

    private void dumpAfter(HttpServletRequest request, HttpServletResponse response) {
        StringBuffer sb = new StringBuffer();
        sb.append(LF);
        sb.append(LF);
        sb.append("** after *****************************************: ");
        sb.append(this.getServletPath((ServletRequest)request));
        sb.append(LF);
        if (this.afterResponse) {
            RequestDumpUtil.dumpResponseProperties(sb, response, LF, INDENT);
        }
        if (this.afterRequestParameter) {
            RequestDumpUtil.dumpRequestParameters(sb, request, LF, INDENT);
        }
        if (this.afterRequestAttribute) {
            RequestDumpUtil.dumpRequestAttributes(sb, request, LF, INDENT);
        }
        if (this.afterCookies) {
            RequestDumpUtil.dumpCookies(sb, request, LF, INDENT);
        }
        if (this.afterRequestHeader) {
            RequestDumpUtil.dumpRequestHeaders(sb, request, LF, INDENT);
        }
        if (this.afterSessionAttribute) {
            RequestDumpUtil.dumpSessionAttributes(sb, request, LF, INDENT);
        }
        if (this.afterContextAttribute) {
            RequestDumpUtil.dumpContextAttributes(sb, this.config.getServletContext(), LF, INDENT);
        }
        log.debug((Object)sb.toString());
    }

    private String getServletPath(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            return ((HttpServletRequest)request).getServletPath();
        }
        return "";
    }

    public String toString() {
        if (this.config == null) {
            return "RequestDumpFilter()";
        }
        StringBuffer sb = new StringBuffer("RequestDumpFilter(");
        sb.append(this.config);
        sb.append(")");
        return sb.toString();
    }

    private boolean getBooleanParameter(FilterConfig filterConfig, String name, boolean defaultValue) {
        String value = filterConfig.getInitParameter(name);
        if (value == null) {
            return defaultValue;
        }
        return BooleanConversionUtil.toPrimitiveBoolean((Object)value);
    }
}

