/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.problem;

import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.util.Util;

public class AbortCompilation
extends RuntimeException {
    public CompilationResult compilationResult;
    public Throwable exception;
    public CategorizedProblem problem;
    public boolean isSilent;
    public RuntimeException silentException;
    private static final long serialVersionUID = -2047226595083244852L;

    public AbortCompilation() {
    }

    public AbortCompilation(CompilationResult compilationResult, CategorizedProblem problem) {
        this();
        this.compilationResult = compilationResult;
        this.problem = problem;
    }

    public AbortCompilation(CompilationResult compilationResult, Throwable exception) {
        this();
        this.compilationResult = compilationResult;
        this.exception = exception;
    }

    public AbortCompilation(boolean isSilent, RuntimeException silentException) {
        this();
        this.isSilent = isSilent;
        this.silentException = silentException;
    }

    public void updateContext(InvocationSite invocationSite, CompilationResult unitResult) {
        if (this.problem == null) {
            return;
        }
        if (this.problem.getSourceStart() != 0 || this.problem.getSourceEnd() != 0) {
            return;
        }
        this.problem.setSourceStart(invocationSite.sourceStart());
        this.problem.setSourceEnd(invocationSite.sourceEnd());
        int[] lineEnds = unitResult.getLineSeparatorPositions();
        this.problem.setSourceLineNumber(Util.getLineNumber(invocationSite.sourceStart(), lineEnds, 0, lineEnds.length - 1));
        this.compilationResult = unitResult;
    }

    public void updateContext(ASTNode astNode, CompilationResult unitResult) {
        if (this.problem == null) {
            return;
        }
        if (this.problem.getSourceStart() != 0 || this.problem.getSourceEnd() != 0) {
            return;
        }
        this.problem.setSourceStart(astNode.sourceStart());
        this.problem.setSourceEnd(astNode.sourceEnd());
        int[] lineEnds = unitResult.getLineSeparatorPositions();
        this.problem.setSourceLineNumber(Util.getLineNumber(astNode.sourceStart(), lineEnds, 0, lineEnds.length - 1));
        this.compilationResult = unitResult;
    }
}

