/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.jpa.impl;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;
import javax.transaction.Synchronization;
import javax.transaction.TransactionSynchronizationRegistry;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.container.annotation.tiger.Component;
import org.seasar.framework.jpa.PersistenceUnitManager;
import org.seasar.framework.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class TxScopedEntityManagerProxy
implements EntityManager {
    private static final Logger logger = Logger.getLogger(TxScopedEntityManagerProxy.class);
    @Binding(bindingType=BindingType.MUST)
    protected TransactionSynchronizationRegistry tsr;
    @Binding(bindingType=BindingType.MUST)
    protected EntityManagerFactory emf;
    @Binding(bindingType=BindingType.MUST)
    protected PersistenceUnitManager pum;

    protected boolean isTxActive() {
        return this.tsr.getTransactionStatus() != 6;
    }

    protected void assertTxActive() {
        if (!this.isTxActive()) {
            throw new TransactionRequiredException();
        }
    }

    protected EntityManager getEntityManager() {
        if (!this.isTxActive()) {
            return this.emf.createEntityManager();
        }
        EntityManager em = this.getTxBoundEntityManager();
        if (em != null) {
            return em;
        }
        return this.createEntityManager();
    }

    protected EntityManager getTxBoundEntityManager() {
        if (!this.isTxActive()) {
            return null;
        }
        return (EntityManager)EntityManager.class.cast(this.tsr.getResource((Object)this.emf));
    }

    protected EntityManager createEntityManager() {
        final EntityManager em = this.emf.createEntityManager();
        this.tsr.putResource((Object)this.emf, (Object)em);
        this.tsr.registerInterposedSynchronization(new Synchronization(){

            public void beforeCompletion() {
            }

            public void afterCompletion(int status) {
                try {
                    em.close();
                }
                catch (Throwable t) {
                    logger.log("ESSR0017", new Object[]{t}, t);
                }
            }
        });
        return em;
    }

    public void clear() {
        if (this.isTxActive()) {
            EntityManager em = this.getEntityManager();
            em.clear();
        }
    }

    public void close() {
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object entity) {
        boolean mustClose = !this.isTxActive();
        EntityManager em = this.getEntityManager();
        try {
            boolean bl = em.contains(entity);
            return bl;
        }
        finally {
            if (mustClose) {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNamedQuery(String name) {
        boolean mustClose = !this.isTxActive();
        EntityManager em = this.getEntityManager();
        try {
            Query query = em.createNamedQuery(name);
            return query;
        }
        finally {
            if (mustClose) {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString) {
        boolean mustClose = !this.isTxActive();
        EntityManager em = this.getEntityManager();
        try {
            Query query = em.createNativeQuery(sqlString);
            return query;
        }
        finally {
            if (mustClose) {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString, Class resultClass) {
        boolean mustClose = !this.isTxActive();
        EntityManager em = this.getEntityManager();
        try {
            Query query = em.createNativeQuery(sqlString, resultClass);
            return query;
        }
        finally {
            if (mustClose) {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        boolean mustClose = !this.isTxActive();
        EntityManager em = this.getEntityManager();
        try {
            Query query = em.createNativeQuery(sqlString, resultSetMapping);
            return query;
        }
        finally {
            if (mustClose) {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery(String qlString) {
        boolean mustClose = !this.isTxActive();
        EntityManager em = this.getEntityManager();
        try {
            Query query = em.createQuery(qlString);
            return query;
        }
        finally {
            if (mustClose) {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        boolean mustClose = !this.isTxActive();
        EntityManager em = this.getEntityManager();
        try {
            Object object = em.find(entityClass, primaryKey);
            return (T)object;
        }
        finally {
            if (mustClose) {
                em.close();
            }
        }
    }

    public void flush() {
        if (this.isTxActive()) {
            EntityManager em = this.getEntityManager();
            em.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDelegate() {
        boolean mustClose = !this.isTxActive();
        EntityManager em = this.getEntityManager();
        try {
            Object object = em.getDelegate();
            return object;
        }
        finally {
            if (mustClose) {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlushModeType getFlushMode() {
        boolean mustClose = !this.isTxActive();
        EntityManager em = this.getEntityManager();
        try {
            FlushModeType flushModeType = em.getFlushMode();
            return flushModeType;
        }
        finally {
            if (mustClose) {
                em.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        boolean mustClose = !this.isTxActive();
        EntityManager em = this.getEntityManager();
        try {
            Object object = em.getReference(entityClass, primaryKey);
            return (T)object;
        }
        finally {
            if (mustClose) {
                em.close();
            }
        }
    }

    public EntityTransaction getTransaction() {
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        boolean mustClose = !this.isTxActive();
        EntityManager em = this.getEntityManager();
        try {
            boolean bl = em.isOpen();
            return bl;
        }
        finally {
            if (mustClose) {
                em.close();
            }
        }
    }

    public void joinTransaction() {
        this.assertTxActive();
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.assertTxActive();
        EntityManager em = this.getEntityManager();
        em.lock(entity, lockMode);
    }

    public <T> T merge(T entity) {
        this.assertTxActive();
        EntityManager em = this.getEntityManager();
        return (T)em.merge(entity);
    }

    public void persist(Object entity) {
        this.assertTxActive();
        EntityManager em = this.getEntityManager();
        em.persist(entity);
    }

    public void refresh(Object entity) {
        this.assertTxActive();
        EntityManager em = this.getEntityManager();
        em.refresh(entity);
    }

    public void remove(Object entity) {
        this.assertTxActive();
        EntityManager em = this.getEntityManager();
        em.remove(entity);
    }

    public void setFlushMode(FlushModeType flushMode) {
        if (this.isTxActive()) {
            EntityManager em = this.getEntityManager();
            em.setFlushMode(flushMode);
        }
    }
}

