/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator.validators;

import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.seasar.cubby.action.MessageInfo;
import org.seasar.cubby.controller.FormatPattern;
import org.seasar.cubby.internal.util.LogMessages;
import org.seasar.cubby.internal.util.StringUtils;
import org.seasar.cubby.spi.ContainerProvider;
import org.seasar.cubby.spi.ProviderFactory;
import org.seasar.cubby.spi.container.Container;
import org.seasar.cubby.validator.ScalarFieldValidator;
import org.seasar.cubby.validator.ValidationContext;

public class DateFormatValidator
implements ScalarFieldValidator {
    private final String messageKey;
    private final String pattern;

    public DateFormatValidator() {
        this(null);
    }

    public DateFormatValidator(String pattern) {
        this(pattern, "valid.dateFormat");
    }

    public DateFormatValidator(String pattern, String messageKey) {
        this.pattern = pattern;
        this.messageKey = messageKey;
    }

    public void validate(ValidationContext context, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            String stringValue = (String)value;
            if (StringUtils.isEmpty((String)value)) {
                return;
            }
            try {
                DateFormat dateFormat = this.createDateFormat(context, value);
                ParsePosition parsePosition = new ParsePosition(0);
                Date date = dateFormat.parse(stringValue, parsePosition);
                if (date != null && parsePosition.getIndex() == stringValue.length()) {
                    return;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setKey(this.messageKey);
        context.addMessageInfo(messageInfo);
    }

    private DateFormat createDateFormat(ValidationContext context, Object value) {
        String pattern;
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        if (StringUtils.isEmpty(this.pattern)) {
            Container container = ProviderFactory.get(ContainerProvider.class).getContainer();
            FormatPattern formatPattern = container.lookup(FormatPattern.class);
            if (formatPattern == null) {
                throw new IllegalStateException(LogMessages.format("ECUB0301", this, value));
            }
            pattern = formatPattern.getDatePattern();
        } else {
            pattern = this.pattern;
        }
        dateFormat.applyPattern(pattern);
        dateFormat.setLenient(false);
        return dateFormat;
    }
}

