/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.xml;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.framework.xml.TagHandlerContext;

public class TagHandlerContextTest
extends TestCase {
    public void testStartElementAndEndElement() throws Exception {
        TagHandlerContext ctx = new TagHandlerContext();
        ctx.startElement("aaa");
        TagHandlerContextTest.assertEquals((String)"1", (String)"/aaa", (String)ctx.getPath());
        TagHandlerContextTest.assertEquals((String)"2", (String)"/aaa[1]", (String)ctx.getDetailPath());
        TagHandlerContextTest.assertEquals((String)"3", (String)"aaa", (String)ctx.getQName());
        ctx.startElement("bbb");
        TagHandlerContextTest.assertEquals((String)"4", (String)"/aaa/bbb", (String)ctx.getPath());
        TagHandlerContextTest.assertEquals((String)"5", (String)"/aaa[1]/bbb[1]", (String)ctx.getDetailPath());
        TagHandlerContextTest.assertEquals((String)"6", (String)"bbb", (String)ctx.getQName());
        ctx.endElement();
        TagHandlerContextTest.assertEquals((String)"7", (String)"/aaa", (String)ctx.getPath());
        TagHandlerContextTest.assertEquals((String)"8", (String)"/aaa[1]", (String)ctx.getDetailPath());
        TagHandlerContextTest.assertEquals((String)"9", (String)"aaa", (String)ctx.getQName());
        ctx.startElement("bbb");
        TagHandlerContextTest.assertEquals((String)"10", (String)"/aaa/bbb", (String)ctx.getPath());
        TagHandlerContextTest.assertEquals((String)"11", (String)"/aaa[1]/bbb[2]", (String)ctx.getDetailPath());
        TagHandlerContextTest.assertEquals((String)"12", (String)"bbb", (String)ctx.getQName());
    }

    public void testPeek() throws Exception {
        TagHandlerContext ctx = new TagHandlerContext();
        ctx.push((Object)"aaa");
        ctx.push(new ArrayList());
        ctx.push((Object)"bbb");
        TagHandlerContextTest.assertNotNull((String)"1", (Object)ctx.peek(List.class));
        TagHandlerContextTest.assertNull((String)"2", (Object)ctx.peek(Integer.class));
        TagHandlerContextTest.assertEquals((String)"3", (Object)"bbb", (Object)ctx.peek(String.class));
    }

    public void testIsEmpty() {
        TagHandlerContext ctx = new TagHandlerContext();
        TagHandlerContextTest.assertTrue((String)"1", (boolean)ctx.isEmpty());
        ctx.push((Object)"aaa");
        TagHandlerContextTest.assertFalse((String)"2", (boolean)ctx.isEmpty());
    }
}

