/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.unit;

import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletOutputStream;
import junitx.framework.ArrayAssert;
import org.seasar.framework.container.TooManyRegistrationRuntimeException;
import org.seasar.framework.container.impl.S2ContainerBehavior;
import org.seasar.framework.container.warmdeploy.WarmdeployBehavior;
import org.seasar.framework.env.Env;
import org.seasar.framework.mock.servlet.MockHttpServletResponse;
import org.seasar.framework.unit.S2FrameworkTestCase;

public class S2FrameworkTestCaseTest
extends S2FrameworkTestCase {
    private static final String J2EE_PATH = "S2FrameworkTestCaseTest_j2ee.dicon";
    private boolean testAaaSetUpInvoked_ = false;
    private Date date_;
    private String ccc_;
    private HashMap bbb_;
    private Date ddd_;
    private List list1;

    public S2FrameworkTestCaseTest() {
    }

    public S2FrameworkTestCaseTest(String name) {
        super(name);
        if (name.equals("testNotWarmdeploy")) {
            this.setWarmDeploy(false);
        }
    }

    public void setUpAaa() {
        this.testAaaSetUpInvoked_ = true;
    }

    public void testAaa() {
        S2FrameworkTestCaseTest.assertEquals((String)"1", (boolean)true, (boolean)this.testAaaSetUpInvoked_);
    }

    public void tearDownAaa() {
        System.out.println("tearDownAaa");
    }

    public void setUpBbbTx() {
        this.include(J2EE_PATH);
    }

    public void testBbbTx() {
        System.out.println("testBbbTx");
    }

    public void setUpBindField() {
        this.include(J2EE_PATH);
        this.register(Date.class);
    }

    public void testBindField() {
        S2FrameworkTestCaseTest.assertNotNull((String)"1", (Object)this.date_);
    }

    public void tearDownBindField() {
        S2FrameworkTestCaseTest.assertNull((Object)this.date_);
    }

    public void setUpBindField2() {
        this.include("bbb.dicon");
    }

    public void testBindField2() {
        S2FrameworkTestCaseTest.assertNotNull((String)"1", (Object)this.bbb_);
        S2FrameworkTestCaseTest.assertNotNull((String)"2", (Object)this.ddd_);
    }

    public void tearDownBindField2() {
        S2FrameworkTestCaseTest.assertNull((Object)this.bbb_);
        S2FrameworkTestCaseTest.assertNull((Object)this.ddd_);
    }

    public void setUpBindField3() {
        this.include("ccc.dicon");
    }

    public void testBindField3() {
        S2FrameworkTestCaseTest.assertNotNull((String)"1", (Object)this.list1);
    }

    public void tearDownBindField3() {
        S2FrameworkTestCaseTest.assertNull((Object)this.list1);
    }

    public void testInclude() {
        this.include("aaa.dicon");
        try {
            this.getComponent(Date.class);
            S2FrameworkTestCaseTest.fail((String)"1");
        }
        catch (TooManyRegistrationRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public void testConvertPath() {
        S2FrameworkTestCaseTest.assertEquals((String)"org/seasar/framework/unit/aaa.dicon", (String)this.convertPath("aaa.dicon"));
        S2FrameworkTestCaseTest.assertEquals((String)"j2ee.dicon", (String)this.convertPath("j2ee.dicon"));
        S2FrameworkTestCaseTest.assertEquals((String)"notfound.dicon", (String)this.convertPath("notfound.dicon"));
    }

    public void setUpIsAssignableFrom() {
        this.include("bbb.dicon");
    }

    public void testIsAssignableFrom() {
        S2FrameworkTestCaseTest.assertEquals((String)"1", (String)"hoge", (String)this.ccc_);
    }

    public void testEmptyComponent() {
        this.include("empty.dicon");
    }

    public void testEnv() throws Exception {
        S2FrameworkTestCaseTest.assertEquals((String)"env_ut.txt", (String)Env.getFilePath());
        S2FrameworkTestCaseTest.assertEquals((String)"ut", (String)Env.getValue());
    }

    public void setUpWarmdeploy() throws Exception {
        this.include("aop.dicon");
    }

    public void testWarmdeploy() throws Exception {
        S2FrameworkTestCaseTest.assertTrue((boolean)(S2ContainerBehavior.getProvider() instanceof WarmdeployBehavior));
        S2FrameworkTestCaseTest.assertNotNull((Object)this.getComponent("fooDao"));
    }

    public void testNotWarmdeploy() throws Exception {
        S2FrameworkTestCaseTest.assertFalse((boolean)(S2ContainerBehavior.getProvider() instanceof WarmdeployBehavior));
    }

    public void testGetResponseString() throws Exception {
        MockHttpServletResponse res = this.getResponse();
        PrintWriter writer = res.getWriter();
        writer.write("ZXCV");
        writer.write("abc");
        S2FrameworkTestCaseTest.assertEquals((String)"ZXCVabc", (String)res.getResponseString());
    }

    public void testGetResponseBytes() throws Exception {
        MockHttpServletResponse res = this.getResponse();
        ServletOutputStream os = res.getOutputStream();
        os.write(new byte[]{3, 2, 1});
        os.write(new byte[]{9, 8, 7, 6});
        byte[] bytes = res.getResponseBytes();
        S2FrameworkTestCaseTest.assertEquals((int)7, (int)bytes.length);
        ArrayAssert.assertEquals((byte[])new byte[]{3, 2, 1, 9, 8, 7, 6}, (byte[])bytes);
    }

    public String getRootDiconGetRootDicon() {
        return "aop.dicon";
    }

    public void testGetRootDicon() throws Throwable {
        S2FrameworkTestCaseTest.assertEquals((String)"aop.dicon", (String)this.resolveRootDicon());
        S2FrameworkTestCaseTest.assertEquals((String)"aop.dicon", (String)this.getContainer().getPath());
    }

    public static class Hoge {
        private String aaa;

        public String getAaa() {
            return this.aaa;
        }

        public void setAaa(String aaa) {
            this.aaa = aaa;
        }
    }
}

