/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.mock.servlet;

import java.net.URL;
import java.util.Set;
import junit.framework.TestCase;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.mock.servlet.MockServletContextImpl;

public class MockServletContextImplTest
extends TestCase {
    private MockServletContextImpl context_;

    public void testCreateRequest() throws Exception {
        MockHttpServletRequest request = this.context_.createRequest("/hello.html");
        MockServletContextImplTest.assertEquals((String)"1", (String)"/s2jsf-example", (String)request.getContextPath());
        MockServletContextImplTest.assertEquals((String)"2", (String)"/hello.html", (String)request.getServletPath());
        request = this.context_.createRequest("/hello.html?aaa=hoge");
        MockServletContextImplTest.assertEquals((String)"3", (String)"aaa=hoge", (String)request.getQueryString());
    }

    public void testGetResourcePaths() throws Exception {
        Set paths = this.context_.getResourcePaths("/lib");
        System.out.println(paths);
        MockServletContextImplTest.assertNotNull((Object)paths);
        MockServletContextImplTest.assertFalse((boolean)paths.isEmpty());
        String path = (String)paths.iterator().next();
        MockServletContextImplTest.assertTrue((boolean)path.startsWith("/lib/"));
        URL url = this.context_.getResource(path);
        System.out.println(url);
        MockServletContextImplTest.assertNotNull((Object)url);
        paths = this.context_.getResourcePaths("/WEB-INF/lib/");
        System.out.println(paths);
        MockServletContextImplTest.assertNotNull((Object)paths);
        MockServletContextImplTest.assertFalse((boolean)paths.isEmpty());
        path = (String)paths.iterator().next();
        MockServletContextImplTest.assertTrue((boolean)path.startsWith("/lib/"));
        url = this.context_.getResource(path);
        System.out.println(url);
        MockServletContextImplTest.assertNotNull((Object)url);
    }

    protected void setUp() throws Exception {
        this.context_ = new MockServletContextImpl("/s2jsf-example");
    }
}

