/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.impl;

import junit.framework.TestCase;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.ComponentNameExpression;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.container.ognl.OgnlExpression;

public class ComponentNameExpressionTest
extends TestCase {
    public static final int COUNT = 1000000;

    public void test() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(Object.class, "foo");
        container.register((ComponentDef)cd);
        ComponentNameExpression expr = new ComponentNameExpression("foo");
        ComponentNameExpressionTest.assertNotNull((Object)expr.evaluate((S2Container)container, null));
    }

    public void testPerf() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(Object.class, "foo");
        container.register((ComponentDef)cd);
        ComponentNameExpression expr = new ComponentNameExpression("foo");
        long t1 = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            expr.evaluate((S2Container)container, null);
        }
        long t2 = System.currentTimeMillis();
        System.out.println("name : " + (t2 - t1) + "ms");
        expr = new OgnlExpression("foo");
        t1 = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            expr.evaluate((S2Container)container, null);
        }
        t2 = System.currentTimeMillis();
        System.out.println("ognl : " + (t2 - t1) + "ms");
    }
}

