/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.hotdeploy;

import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.ComponentCreator;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.creator.ActionCreator;
import org.seasar.framework.container.creator.ConverterCreator;
import org.seasar.framework.container.creator.DaoCreator;
import org.seasar.framework.container.creator.DtoCreator;
import org.seasar.framework.container.creator.DxoCreator;
import org.seasar.framework.container.creator.HelperCreator;
import org.seasar.framework.container.creator.InterceptorCreator;
import org.seasar.framework.container.creator.LogicCreator;
import org.seasar.framework.container.creator.PageCreator;
import org.seasar.framework.container.creator.ServiceCreator;
import org.seasar.framework.container.creator.ValidatorCreator;
import org.seasar.framework.container.hotdeploy.HotdeployBehavior;
import org.seasar.framework.container.hotdeploy.creator.web.aaa.HogePage;
import org.seasar.framework.container.impl.S2ContainerBehavior;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.convention.impl.NamingConventionImpl;
import org.seasar.framework.unit.S2FrameworkTestCase;
import org.seasar.framework.util.ClassUtil;

public class HotdeployBehavior2Test
extends S2FrameworkTestCase {
    private ClassLoader originalLoader;
    private HotdeployBehavior ondemand;
    private String rootPackageName = ClassUtil.getPackageName(((Object)((Object)this)).getClass()) + ".creator";

    protected void setUp() {
        this.register(HogePage.class);
        this.originalLoader = Thread.currentThread().getContextClassLoader();
        NamingConventionImpl convention = new NamingConventionImpl();
        convention.addRootPackageName(this.rootPackageName);
        this.ondemand = new HotdeployBehavior();
        this.ondemand.setNamingConvention((NamingConvention)convention);
        this.ondemand.setCreators(new ComponentCreator[]{new ConverterCreator((NamingConvention)convention), new DaoCreator((NamingConvention)convention), new DtoCreator((NamingConvention)convention), new DxoCreator((NamingConvention)convention), new HelperCreator((NamingConvention)convention), new InterceptorCreator((NamingConvention)convention), new LogicCreator((NamingConvention)convention), new ServiceCreator((NamingConvention)convention), new ValidatorCreator((NamingConvention)convention), new ActionCreator((NamingConvention)convention), new PageCreator((NamingConvention)convention)});
        S2ContainerBehavior.setProvider((S2ContainerBehavior.Provider)this.ondemand);
        this.ondemand.start();
    }

    protected void tearDown() {
        this.ondemand.stop();
        S2ContainerBehavior.setProvider((S2ContainerBehavior.Provider)new S2ContainerBehavior.DefaultProvider());
        Thread.currentThread().setContextClassLoader(this.originalLoader);
    }

    public void testCreateComponentDef() throws Exception {
        Class clazz = ClassUtil.forName((String)(this.rootPackageName + ".web.aaa.HogeAction"));
        HotdeployBehavior2Test.assertNotNull((Object)this.ondemand.acquireFromGetComponentDef(this.getContainer(), (Object)clazz));
    }

    public void testHasComponentDef() throws Exception {
        HotdeployBehavior2Test.assertTrue((boolean)this.getContainer().hasComponentDef((Object)"aaa_hogeAction"));
        HotdeployBehavior2Test.assertFalse((boolean)this.getContainer().hasComponentDef((Object)"xxx"));
    }

    public void testGetComponentDefFromCache() throws Exception {
        Class clazz = ClassUtil.forName((String)(this.rootPackageName + ".web.aaa.HogeAction"));
        ComponentDef cd = this.ondemand.acquireFromGetComponentDef(this.getContainer(), (Object)clazz);
        HotdeployBehavior2Test.assertSame((Object)cd, (Object)this.ondemand.acquireFromGetComponentDef(this.getContainer(), (Object)clazz));
    }

    public void testGetComponent() throws Exception {
        Object o = this.getComponent("aaa_hogeAction");
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(o.getClass());
        PropertyDesc pd = beanDesc.getPropertyDesc("hogePage");
        HotdeployBehavior2Test.assertEquals((Object)HogePage.class, (Object)pd.getPropertyType());
    }

    public void testGetComponent2() throws Exception {
        try {
            this.getComponent("aaa_HogeAction");
            HotdeployBehavior2Test.fail();
        }
        catch (ComponentNotFoundRuntimeException e) {
            HotdeployBehavior2Test.assertEquals((Object)"aaa_HogeAction", (Object)e.getComponentKey());
        }
    }
}

