/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.factory;

import java.util.Date;
import junit.framework.TestCase;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.env.Env;

public class IncludeTagHandlerTest
extends TestCase {
    private static final String PATH = "org/seasar/framework/container/factory/IncludeTagHandlerTest.dicon";
    private static final String PATH2 = "org/seasar/framework/container/factory/IncludeTagHandlerTest2.dicon";
    private static final String AAA_PATH = "org/seasar/framework/container/factory/aaa.dicon";
    private static final String ENV_PATH = "org/seasar/framework/container/factory/env.txt";

    protected void setUp() {
        Env.setFilePath((String)ENV_PATH);
    }

    protected void tearDown() {
        Env.initialize();
    }

    public void testInclude() throws Exception {
        S2Container container = S2ContainerFactory.create((String)PATH);
        IncludeTagHandlerTest.assertEquals((String)"1", (Object)new Date(0L), (Object)container.getComponent((Object)Date.class));
    }

    public void testInclude2() throws Exception {
        S2Container container = S2ContainerFactory.create((String)AAA_PATH);
        IncludeTagHandlerTest.assertSame((String)"1", (Object)container.getComponent((Object)"aaa.cdate"), (Object)container.getComponent((Object)"bbb.cdate"));
    }

    public void testInclude3() throws Exception {
        S2Container container = S2ContainerFactory.create((String)PATH);
        S2Container grandChild = (S2Container)container.getComponent((Object)"grandChild");
        S2Container child = (S2Container)container.getComponent((Object)"child");
        S2Container grandChild2 = (S2Container)child.getComponent((Object)"grandChild");
        IncludeTagHandlerTest.assertSame((String)"1", (Object)grandChild, (Object)grandChild2);
    }

    public void testInclude_condition() throws Exception {
        S2Container container = S2ContainerFactory.create((String)PATH2);
        IncludeTagHandlerTest.assertFalse((boolean)container.hasComponentDef((Object)"child"));
        IncludeTagHandlerTest.assertTrue((boolean)container.hasComponentDef((Object)"grandChild"));
    }
}

