/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.deployer;

import java.util.HashMap;
import junit.framework.TestCase;
import org.seasar.framework.container.ArgDef;
import org.seasar.framework.container.ClassUnmatchRuntimeException;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.InitMethodDef;
import org.seasar.framework.container.deployer.OuterComponentDeployer;
import org.seasar.framework.container.impl.ArgDefImpl;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.InitMethodDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.util.ArrayMap;
import org.seasar.framework.util.CaseInsensitiveMap;

public class OuterComponentDeployerTest
extends TestCase {
    public void testInjectDependency() throws Exception {
        ComponentDefImpl cd = new ComponentDefImpl(HashMap.class);
        InitMethodDefImpl md = new InitMethodDefImpl("put");
        md.addArgDef((ArgDef)new ArgDefImpl((Object)"aaa"));
        md.addArgDef((ArgDef)new ArgDefImpl((Object)"hoge"));
        cd.addInitMethodDef((InitMethodDef)md);
        OuterComponentDeployer deployer = new OuterComponentDeployer((ComponentDef)cd);
        HashMap myMap = new HashMap();
        deployer.injectDependency(myMap);
        OuterComponentDeployerTest.assertEquals((String)"1", (Object)"hoge", myMap.get("aaa"));
    }

    public void testInjectDependency2() throws Exception {
        ComponentDefImpl cd = new ComponentDefImpl(ArrayMap.class);
        InitMethodDefImpl md = new InitMethodDefImpl("put");
        md.addArgDef((ArgDef)new ArgDefImpl((Object)"aaa"));
        md.addArgDef((ArgDef)new ArgDefImpl((Object)"hoge"));
        cd.addInitMethodDef((InitMethodDef)md);
        OuterComponentDeployer deployer = new OuterComponentDeployer((ComponentDef)cd);
        CaseInsensitiveMap myMap = new CaseInsensitiveMap();
        deployer.injectDependency((Object)myMap);
        OuterComponentDeployerTest.assertEquals((String)"1", (Object)"hoge", myMap.get("aaa"));
        try {
            HashMap myMap2 = new HashMap();
            deployer.injectDependency(myMap2);
            OuterComponentDeployerTest.fail((String)"1");
        }
        catch (ClassUnmatchRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public void testDeploy() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(HashMap.class);
        container.register((ComponentDef)cd);
        OuterComponentDeployer deployer = new OuterComponentDeployer((ComponentDef)cd);
        try {
            deployer.deploy();
            OuterComponentDeployerTest.fail((String)"1");
        }
        catch (UnsupportedOperationException ex) {
            System.out.println(ex);
        }
    }

    public static class C
    implements Hoge {
        private Foo foo_;

        public void setFoo(Foo foo) {
            this.foo_ = foo;
        }

        public String getName() {
            return "C";
        }

        public String getHogeName() {
            return this.foo_.getHogeName();
        }
    }

    public static class B
    implements Hoge {
        public String getName() {
            return "B";
        }
    }

    public static interface Hoge {
        public String getName();
    }

    public static class A2
    implements Foo {
        private Hoge hoge_;

        public void setHoge(Hoge hoge) {
            this.hoge_ = hoge;
        }

        public String getHogeName() {
            return this.hoge_.getName();
        }
    }

    public static class A {
        private Hoge hoge_;

        public A(Hoge hoge) {
            this.hoge_ = hoge;
        }

        public String getHogeName() {
            return this.hoge_.getName();
        }
    }

    public static interface Foo {
        public String getHogeName();
    }
}

