/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import java.util.Date;
import junit.framework.TestCase;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.ExternalContext;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.assembler.AutoBindingDefFactory;
import org.seasar.framework.container.assembler.AutoPropertyAssembler;
import org.seasar.framework.container.external.servlet.HttpServletExternalContext;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.PropertyDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.mock.servlet.MockHttpServletRequest;
import org.seasar.framework.mock.servlet.MockServletContextImpl;

public class AutoPropertyAssemblerTest
extends TestCase {
    public void testAssemble() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        container.register((ComponentDef)cd);
        container.register(B.class);
        AutoPropertyAssembler assembler = new AutoPropertyAssembler((ComponentDef)cd);
        A a = new A();
        assembler.assemble((Object)a);
        AutoPropertyAssemblerTest.assertEquals((String)"1", (String)"B", (String)a.getHogeName());
    }

    public void testAssemble2() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        cd.addPropertyDef((PropertyDef)new PropertyDefImpl("message", (Object)"aaa"));
        container.register((ComponentDef)cd);
        container.register(B.class);
        AutoPropertyAssembler assembler = new AutoPropertyAssembler((ComponentDef)cd);
        A a = new A();
        assembler.assemble((Object)a);
        AutoPropertyAssemblerTest.assertEquals((String)"1", (String)"B", (String)a.getHogeName());
        AutoPropertyAssemblerTest.assertEquals((String)"2", (String)"aaa", (String)a.getMessage());
    }

    public void testAssembleNotInterface() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(Date.class);
        container.register((ComponentDef)cd);
        AutoPropertyAssembler assembler = new AutoPropertyAssembler((ComponentDef)cd);
        Date d = new Date();
        assembler.assemble((Object)d);
    }

    public void testAssembleWhenComponentNull() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(Date.class);
        container.register((ComponentDef)cd);
        AutoPropertyAssembler assembler = new AutoPropertyAssembler((ComponentDef)cd);
        assembler.assemble(null);
    }

    public void testSkipIllegalProperty() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A.class);
        container.register((ComponentDef)cd);
        AutoPropertyAssembler assembler = new AutoPropertyAssembler((ComponentDef)cd);
        A a = new A();
        assembler.assemble((Object)a);
    }

    public void testSkipWarning() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(A2.class);
        container.register((ComponentDef)cd);
        AutoPropertyAssembler assembler = new AutoPropertyAssembler((ComponentDef)cd);
        A2 a2 = new A2();
        assembler.assemble((Object)a2);
        AutoPropertyAssemblerTest.assertEquals((String)"1", (String)"B", (String)a2.getHogeName());
    }

    public void testBindExternally() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(D.class);
        cd.setAutoBindingDef(AutoBindingDefFactory.NONE);
        cd.setExternalBinding(true);
        container.register((ComponentDef)cd);
        HttpServletExternalContext extCtx = new HttpServletExternalContext();
        MockServletContextImpl servletContext = new MockServletContextImpl("s2-example");
        MockHttpServletRequest request = servletContext.createRequest("/hello.html");
        request.setParameter("name", "aaa");
        extCtx.setRequest((Object)request);
        container.setExternalContext((ExternalContext)extCtx);
        AutoPropertyAssembler assembler = new AutoPropertyAssembler((ComponentDef)cd);
        D d = new D();
        assembler.assemble((Object)d);
        AutoPropertyAssemblerTest.assertEquals((String)"1", (String)"aaa", (String)d.getName());
    }

    public void testPublicField() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(Ggg.class);
        container.register((ComponentDef)cd);
        container.register(Eee.class, "eee");
        AutoPropertyAssembler assembler = new AutoPropertyAssembler((ComponentDef)cd);
        Ggg ggg = new Ggg();
        assembler.assemble((Object)ggg);
        AutoPropertyAssemblerTest.assertNotNull((Object)ggg.eee);
    }

    public void testPublicFieldBindExternally() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(Ggg.class);
        cd.setAutoBindingDef(AutoBindingDefFactory.NONE);
        cd.setExternalBinding(true);
        container.register((ComponentDef)cd);
        HttpServletExternalContext extCtx = new HttpServletExternalContext();
        MockServletContextImpl servletContext = new MockServletContextImpl("s2-example");
        MockHttpServletRequest request = servletContext.createRequest("/hello.html");
        request.setParameter("name", "aaa");
        extCtx.setRequest((Object)request);
        container.setExternalContext((ExternalContext)extCtx);
        AutoPropertyAssembler assembler = new AutoPropertyAssembler((ComponentDef)cd);
        Ggg ggg = new Ggg();
        assembler.assemble((Object)ggg);
        AutoPropertyAssemblerTest.assertEquals((String)"aaa", (String)ggg.name);
    }

    public static class Ggg {
        public Eee eee;
        public String name;
    }

    public static class Eee {
    }

    public static class D {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class C
    implements Hoge {
        public String getName() {
            return "C";
        }
    }

    public static class B
    implements Hoge {
        public String getName() {
            return "B";
        }
    }

    public static interface Hoge {
        public String getName();
    }

    public static class A2
    implements Foo {
        private Hoge hoge_ = new B();

        public Hoge getHoge() {
            return this.hoge_;
        }

        public void setHoge(Hoge hoge) {
            this.hoge_ = hoge;
        }

        public String getHogeName() {
            return this.hoge_.getName();
        }
    }

    public static class A
    implements Foo {
        private Hoge hoge_;
        private String message_;

        public Hoge getHoge() {
            return this.hoge_;
        }

        public void setHoge(Hoge hoge) {
            this.hoge_ = hoge;
        }

        public String getMessage() {
            return this.message_;
        }

        public void setMessage(String message) {
            this.message_ = message;
        }

        public String getHogeName() {
            return this.hoge_.getName();
        }
    }

    public static interface Foo {
        public String getHogeName();
    }
}

