/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.PropertyDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.assembler.AccessTypeDefFactory;
import org.seasar.framework.container.assembler.AutoBindingDefFactory;
import org.seasar.framework.container.deployer.InstanceDefFactory;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.PropertyDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;

public class AbstBindingTypeDefTest
extends TestCase {
    public void testBindingComponentDef() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        container.register(ComponentDefAware.class);
        ComponentDef cd = container.getComponentDef((Object)ComponentDefAware.class);
        ComponentDefAware cdAware = (ComponentDefAware)cd.getComponent();
        AbstBindingTypeDefTest.assertSame((String)"1", (Object)cd, (Object)cdAware.getComponentDef());
    }

    public void testBindAutoForField() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(Hoge.class);
        container.register((ComponentDef)cd);
        container.register(new ArrayList());
        container.register(new ArrayList());
        Hoge hoge = (Hoge)container.getComponent((Object)Hoge.class);
        AbstBindingTypeDefTest.assertNull((String)"1", (Object)hoge.aaa);
    }

    public void testBindAutoForField2() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(Hoge2.class);
        cd.setAutoBindingDef(AutoBindingDefFactory.SEMIAUTO);
        PropertyDefImpl propDef = new PropertyDefImpl("aaa");
        propDef.setAccessTypeDef(AccessTypeDefFactory.FIELD);
        cd.addPropertyDef((PropertyDef)propDef);
        container.register((ComponentDef)cd);
        container.register((Object)new Hoge3());
        Hoge2 hoge2 = (Hoge2)container.getComponent((Object)Hoge2.class);
        AbstBindingTypeDefTest.assertNotNull((String)"1", (Object)hoge2.aaa);
    }

    public void testBindAutoForField3() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(Hoge5.class);
        cd.setAutoBindingDef(AutoBindingDefFactory.SEMIAUTO);
        cd.setInstanceDef(InstanceDefFactory.PROTOTYPE);
        PropertyDefImpl propDef = new PropertyDefImpl("other");
        propDef.setAccessTypeDef(AccessTypeDefFactory.FIELD);
        cd.addPropertyDef((PropertyDef)propDef);
        propDef = new PropertyDefImpl("list");
        propDef.setAccessTypeDef(AccessTypeDefFactory.FIELD);
        cd.addPropertyDef((PropertyDef)propDef);
        container.register((ComponentDef)cd);
        container.register(new ArrayList());
        Hoge5 hoge5 = (Hoge5)container.getComponent((Object)Hoge5.class);
        AbstBindingTypeDefTest.assertNull((Object)hoge5.list);
        AbstBindingTypeDefTest.assertNull((Object)hoge5.other);
    }

    public void testBindAutoForProperty() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(Hoge5.class);
        cd.setInstanceDef(InstanceDefFactory.PROTOTYPE);
        container.register((ComponentDef)cd);
        container.register(new ArrayList());
        Hoge5 hoge = (Hoge5)container.getComponent((Object)Hoge5.class);
        AbstBindingTypeDefTest.assertNull((Object)hoge.list);
        AbstBindingTypeDefTest.assertNull((Object)hoge.other);
    }

    public void testBindAutoForPackagePrefix() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(Hoge.class, "aaa_hoge");
        ComponentDefImpl cd2 = new ComponentDefImpl(Foo.class);
        container.register((ComponentDef)cd);
        container.register((ComponentDef)cd2);
        container.register(Foo3.class);
        Foo foo = (Foo)container.getComponent((Object)Foo.class);
        AbstBindingTypeDefTest.assertNotNull((Object)foo.getHoge());
        Foo3 foo3 = (Foo3)container.getComponent((Object)Foo3.class);
        AbstBindingTypeDefTest.assertNotNull((Object)foo3.getHoGe());
    }

    public void testBindAutoForArray() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        container.register(Foo2.class);
        container.register(Hoge3.class);
        container.register(Hoge4.class);
        Foo2 foo2 = (Foo2)container.getComponent((Object)Foo2.class);
        AbstBindingTypeDefTest.assertNotNull((Object)foo2.getHoges());
    }

    public void testBindAutoForArray2() throws Exception {
        S2ContainerImpl container0 = new S2ContainerImpl();
        container0.setPath("0");
        container0.register(MapArrayHolder.class);
        S2ContainerImpl container1 = new S2ContainerImpl();
        container1.setPath("1");
        container1.register(MapArrayHolder.class);
        container1.register(HashMap.class);
        container0.include((S2Container)container1);
        S2ContainerImpl container2 = new S2ContainerImpl();
        container2.setPath("2");
        container2.register(MapArrayHolder.class);
        container2.register(HashMap.class);
        container2.register(HashMap.class);
        container1.include((S2Container)container2);
        S2ContainerImpl container3 = new S2ContainerImpl();
        container3.setPath("3");
        container3.register(MapArrayHolder.class);
        container3.register(HashMap.class);
        container3.register(HashMap.class);
        container3.register(HashMap.class);
        container2.include((S2Container)container3);
        S2ContainerImpl container4 = new S2ContainerImpl();
        container4.setPath("4");
        container4.register(MapArrayHolder.class);
        container4.register(HashMap.class);
        container4.register(HashMap.class);
        container4.register(HashMap.class);
        container4.register(HashMap.class);
        container3.include((S2Container)container4);
        container0.init();
        MapArrayHolder holder = (MapArrayHolder)container0.getComponent((Object)MapArrayHolder.class);
        AbstBindingTypeDefTest.assertEquals((int)10, (int)holder.maps.length);
        holder = (MapArrayHolder)container1.getComponent((Object)MapArrayHolder.class);
        AbstBindingTypeDefTest.assertEquals((int)10, (int)holder.maps.length);
        holder = (MapArrayHolder)container2.getComponent((Object)MapArrayHolder.class);
        AbstBindingTypeDefTest.assertEquals((int)9, (int)holder.maps.length);
        holder = (MapArrayHolder)container3.getComponent((Object)MapArrayHolder.class);
        AbstBindingTypeDefTest.assertEquals((int)7, (int)holder.maps.length);
        holder = (MapArrayHolder)container4.getComponent((Object)MapArrayHolder.class);
        AbstBindingTypeDefTest.assertEquals((int)4, (int)holder.maps.length);
    }

    public void testBindAutoForArrayField() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        container.register(Foo4.class);
        container.register(Hoge3.class);
        container.register(Hoge4.class);
        Foo4 foo4 = (Foo4)container.getComponent((Object)Foo4.class);
        AbstBindingTypeDefTest.assertNull((Object)foo4.hoges);
    }

    public void testBindAutoForArrayField2() throws Exception {
        S2ContainerImpl container = new S2ContainerImpl();
        ComponentDefImpl cd = new ComponentDefImpl(Foo4.class);
        cd.setAutoBindingDef(AutoBindingDefFactory.SEMIAUTO);
        PropertyDefImpl propDef = new PropertyDefImpl("hoges");
        propDef.setAccessTypeDef(AccessTypeDefFactory.FIELD);
        cd.addPropertyDef((PropertyDef)propDef);
        container.register((ComponentDef)cd);
        container.register(Hoge3.class);
        container.register(Hoge4.class);
        Foo4 foo4 = (Foo4)container.getComponent((Object)Foo4.class);
        AbstBindingTypeDefTest.assertNotNull((Object)foo4.hoges);
    }

    public static class MapArrayHolder {
        Map[] maps;

        public void setMaps(Map[] maps) {
            this.maps = maps;
        }
    }

    public static class Foo4 {
        IHoge[] hoges;
    }

    public static class Foo3 {
        private Hoge hoGe;

        public Hoge getHoGe() {
            return this.hoGe;
        }

        public void setHoGe(Hoge hoGe) {
            this.hoGe = hoGe;
        }
    }

    public static class Foo2 {
        private IHoge[] hoges;

        public IHoge[] getHoges() {
            return this.hoges;
        }

        public void setHoges(IHoge[] hoges) {
            this.hoges = hoges;
        }
    }

    public static class Foo {
        private Hoge hoge;

        public Hoge getHoge() {
            return this.hoge;
        }

        public void setHoge(Hoge hoge) {
            this.hoge = hoge;
        }
    }

    public static class Hoge5 {
        public ArrayList list;
        public Hoge5 other;
    }

    public static class Hoge4
    extends Hoge3 {
    }

    public static class Hoge3
    implements IHoge {
    }

    public static interface IHoge {
    }

    public static class Hoge2 {
        private IHoge aaa;
    }

    public static class Hoge {
        private List aaa;

        public List getAaa() {
            return this.aaa;
        }
    }

    public static class ComponentDefAware {
        private ComponentDef componentDef;

        public ComponentDef getComponentDef() {
            return this.componentDef;
        }

        public void setComponentDef(ComponentDef componentDef) {
            this.componentDef = componentDef;
        }
    }
}

