/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.beans.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import junit.framework.TestCase;
import org.seasar.framework.beans.IllegalDiiguRuntimeException;
import org.seasar.framework.beans.MethodNotFoundRuntimeException;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.impl.BeanDescImpl;

public class BeanDescImplTest
extends TestCase {
    public void testPropertyDesc() throws Exception {
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        BeanDescImplTest.assertEquals((int)5, (int)beanDesc.getPropertyDescSize());
        PropertyDesc propDesc = beanDesc.getPropertyDesc("aaa");
        BeanDescImplTest.assertEquals((String)"aaa", (String)propDesc.getPropertyName());
        BeanDescImplTest.assertEquals((Object)String.class, (Object)propDesc.getPropertyType());
        BeanDescImplTest.assertNotNull((Object)propDesc.getReadMethod());
        BeanDescImplTest.assertNull((Object)propDesc.getWriteMethod());
        BeanDescImplTest.assertNotNull((Object)propDesc.getField());
        propDesc = beanDesc.getPropertyDesc("CCC");
        BeanDescImplTest.assertEquals((String)"CCC", (String)propDesc.getPropertyName());
        BeanDescImplTest.assertEquals(Boolean.TYPE, (Object)propDesc.getPropertyType());
        BeanDescImplTest.assertNotNull((Object)propDesc.getReadMethod());
        BeanDescImplTest.assertNull((Object)propDesc.getWriteMethod());
        propDesc = beanDesc.getPropertyDesc("eee");
        BeanDescImplTest.assertEquals((String)"eee", (String)propDesc.getPropertyName());
        BeanDescImplTest.assertEquals((Object)String.class, (Object)propDesc.getPropertyType());
        BeanDescImplTest.assertNotNull((Object)propDesc.getReadMethod());
        BeanDescImplTest.assertNotNull((Object)propDesc.getWriteMethod());
        propDesc = beanDesc.getPropertyDesc("fff");
        BeanDescImplTest.assertEquals((String)"fff", (String)propDesc.getPropertyName());
        BeanDescImplTest.assertEquals((Object)Boolean.class, (Object)propDesc.getPropertyType());
        BeanDescImplTest.assertFalse((boolean)beanDesc.hasPropertyDesc("hhh"));
        BeanDescImplTest.assertFalse((boolean)beanDesc.hasPropertyDesc("iii"));
    }

    public void testInvoke() throws Exception {
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        BeanDescImplTest.assertEquals((String)"1", (Object)new Integer(3), (Object)beanDesc.invoke((Object)new MyBean(), "add", new Object[]{new Integer(1), new Integer(2)}));
    }

    public void testInvoke2() throws Exception {
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        BeanDescImplTest.assertEquals((String)"1", (Object)new Integer(3), (Object)beanDesc.invoke((Object)new MyBean(), "add2", new Object[]{new BigDecimal(1.0), new BigDecimal(2.0)}));
    }

    public void testInvoke3() throws Exception {
        BeanDescImpl beanDesc = new BeanDescImpl(Math.class);
        BeanDescImplTest.assertEquals((String)"1", (Object)new Integer(3), (Object)beanDesc.invoke(null, "max", new Object[]{new Integer(1), new Integer(3)}));
        BeanDescImplTest.assertEquals((String)"2", (Object)new Long(3L), (Object)beanDesc.invoke(null, "max", new Object[]{new Long(1L), new Long(3L)}));
    }

    public void testInvoke4() throws Exception {
        BeanDescImpl beanDesc = new BeanDescImpl(Math.class);
        BeanDescImplTest.assertEquals((String)"1", (Object)new Double(3.0), (Object)beanDesc.invoke(null, "ceil", new Object[]{new BigDecimal(2.1)}));
    }

    public void testInvoke5() throws Exception {
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        BeanDescImplTest.assertEquals((String)"1", (Object)new Integer("3"), (Object)beanDesc.invoke((Object)new MyBean(), "echo", new Object[]{new Double("3")}));
    }

    public void testInvokeForException() throws Exception {
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        try {
            beanDesc.invoke((Object)new MyBean(), "throwException", null);
            BeanDescImplTest.fail((String)"1");
        }
        catch (IllegalStateException ex) {
            System.out.println(ex);
        }
    }

    public void testNewInstance() throws Exception {
        BeanDescImpl beanDesc = new BeanDescImpl(Integer.class);
        Integer i = new Integer(10);
        Object[] args = new Object[]{i};
        BeanDescImplTest.assertEquals((String)"1", (Object)i, (Object)beanDesc.newInstance(args));
        Object[] args2 = new Object[]{"10"};
        BeanDescImplTest.assertEquals((String)"2", (Object)i, (Object)beanDesc.newInstance(args2));
    }

    public void testNewInstance2() throws Exception {
        BeanDescImpl beanDesc = new BeanDescImpl(Integer.class);
        BigDecimal d = new BigDecimal(10.0);
        Object[] args = new Object[]{d};
        BeanDescImplTest.assertEquals((String)"1", (Object)new Integer(10), (Object)beanDesc.newInstance(args));
    }

    public void testGetFields() throws Exception {
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        BeanDescImplTest.assertTrue((String)"1", (boolean)beanDesc.hasField("HOGE"));
        Field field = beanDesc.getField("HOGE");
        BeanDescImplTest.assertEquals((String)"2", (Object)"hoge2", (Object)field.get(null));
        BeanDescImplTest.assertTrue((String)"3", (boolean)beanDesc.hasField("aaa"));
        BeanDescImplTest.assertFalse((String)"4", (boolean)beanDesc.hasField("aaA"));
    }

    public void testHasMethod() throws Exception {
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        BeanDescImplTest.assertTrue((boolean)beanDesc.hasMethod("getAaa"));
        BeanDescImplTest.assertFalse((boolean)beanDesc.hasMethod("getaaa"));
    }

    public void testGetMethod() throws Exception {
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        Method method = beanDesc.getMethod("getAaa", new Class[0]);
        BeanDescImplTest.assertNotNull((Object)method);
        BeanDescImplTest.assertEquals((String)"getAaa", (String)method.getName());
        try {
            beanDesc.getMethod("getaaa", null);
            BeanDescImplTest.fail();
        }
        catch (MethodNotFoundRuntimeException methodNotFoundRuntimeException) {
            // empty catch block
        }
    }

    public void testGetMethodNoException() throws Exception {
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        Method method = beanDesc.getMethodNoException("getAaa", new Class[0]);
        BeanDescImplTest.assertNotNull((Object)method);
        BeanDescImplTest.assertEquals((String)"getAaa", (String)method.getName());
        method = beanDesc.getMethodNoException("getaaa", new Class[0]);
        BeanDescImplTest.assertNull((Object)method);
    }

    public void testGetMethodNames() throws Exception {
        BeanDescImpl beanDesc = new BeanDescImpl(((Object)((Object)this)).getClass());
        String[] names = beanDesc.getMethodNames();
        for (int i = 0; i < names.length; ++i) {
            System.out.println(names[i]);
        }
        BeanDescImplTest.assertTrue((String)"1", (names.length > 0 ? 1 : 0) != 0);
    }

    public void testInvalidProperty() throws Exception {
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean2.class);
        BeanDescImplTest.assertEquals((String)"1", (boolean)false, (boolean)beanDesc.hasPropertyDesc("aaa"));
    }

    public void testAddFields() throws Exception {
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        Field eee = beanDesc.getField("eee");
        BeanDescImplTest.assertTrue((boolean)eee.isAccessible());
        PropertyDesc pd = beanDesc.getPropertyDesc("ggg");
        BeanDescImplTest.assertNotNull((Object)pd);
        BeanDescImplTest.assertEquals((String)"ggg", (String)pd.getPropertyName());
        BeanDescImplTest.assertEquals((Object)String.class, (Object)pd.getPropertyType());
    }

    public void testGetMethodParameterNames() throws Exception {
        BeanDescImpl beanDesc = new BeanDescImpl(MyBean.class);
        Method m = beanDesc.getMethod("echo", new Class[]{Integer.class});
        try {
            beanDesc.getMethodParameterNames(m);
            BeanDescImplTest.fail();
        }
        catch (IllegalDiiguRuntimeException e) {
            BeanDescImplTest.assertTrue((boolean)true);
        }
    }

    public static class MyBean3 {
        public MyBean3() {
        }

        public MyBean3(int num, String text, MyBean bean1, MyBean2 bean2) {
        }

        public static void foo(MyBean foo$bar, MyBean2 hoge$hoge$hoge) {
        }
    }

    public class MyBean2 {
        public MyBean2() {
        }

        public MyBean2(int num, String text, MyBean bean1, MyBean2 bean2) {
        }

        public void setAaa(int i) {
        }

        public void setAaa(String s) {
        }
    }

    public static class MyBean
    implements MyInterface2 {
        private String aaa;
        private String eee;
        public String ggg;

        public String getAaa() {
            return this.aaa;
        }

        public String getBbb(Object a) {
            return null;
        }

        public boolean isCCC() {
            return true;
        }

        public Object isDdd() {
            return null;
        }

        public String getEee() {
            return this.eee;
        }

        public void setEee(String eee) {
            this.eee = eee;
        }

        public Boolean isFff() {
            return null;
        }

        public MyBean setHhh(String hhh) {
            return this;
        }

        public void getIii() {
        }

        public Number add(Number arg1, Number arg2) {
            return new Integer(3);
        }

        public int add2(int arg1, int arg2) {
            return arg1 + arg2;
        }

        public Integer echo(Integer arg) {
            return arg;
        }

        public void throwException() {
            throw new IllegalStateException("hoge");
        }
    }

    public static interface MyInterface2
    extends MyInterface {
        public static final String HOGE = "hoge2";
    }

    public static interface MyInterface {
        public static final String HOGE = "hoge";
    }
}

