/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import java.util.Date;
import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInterceptor;
import org.seasar.framework.aop.Aspect;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.impl.AspectImpl;
import org.seasar.framework.aop.impl.PointcutImpl;
import org.seasar.framework.aop.interceptors.ClassLoaderAwareTraceInterceptor;
import org.seasar.framework.aop.proxy.AopProxy;

public class ClassLoaderAwareTraceInterceptorTest
extends TestCase {
    public void testIntercept() throws Exception {
        ClassLoaderAwareTraceInterceptor interceptor = new ClassLoaderAwareTraceInterceptor();
        PointcutImpl pointcut = new PointcutImpl(new String[]{"getTime"});
        AspectImpl aspect = new AspectImpl((MethodInterceptor)interceptor, (Pointcut)pointcut);
        AopProxy aopProxy = new AopProxy(Date.class, new Aspect[]{aspect});
        Date proxy = (Date)aopProxy.create();
        proxy.getTime();
    }

    public void testIntercept2() throws Exception {
        ClassLoaderAwareTraceInterceptor interceptor = new ClassLoaderAwareTraceInterceptor();
        PointcutImpl pointcut = new PointcutImpl(new String[]{"hoge"});
        AspectImpl aspect = new AspectImpl((MethodInterceptor)interceptor, (Pointcut)pointcut);
        AopProxy aopProxy = new AopProxy(ThrowError.class, new Aspect[]{aspect});
        ThrowError proxy = (ThrowError)aopProxy.create();
        try {
            proxy.hoge();
        }
        catch (Throwable ignore) {
            // empty catch block
        }
    }

    public void testIntercept3() throws Exception {
        ClassLoaderAwareTraceInterceptor interceptor = new ClassLoaderAwareTraceInterceptor();
        PointcutImpl pointcut = new PointcutImpl(new String[]{"foo"});
        AspectImpl aspect = new AspectImpl((MethodInterceptor)interceptor, (Pointcut)pointcut);
        AopProxy aopProxy = new AopProxy(Hoge.class, new Aspect[]{aspect});
        Hoge hoge = (Hoge)aopProxy.create();
        hoge.foo(new Foo("a"));
    }

    public static class Foo {
        private String s;

        public Foo(String s) {
            this.s = s;
        }

        public String getS() {
            return this.s;
        }
    }

    public static class Hoge {
        public Foo foo(Foo f) {
            return new Foo(f.getS());
        }
    }

    public static class ThrowError {
        public void hoge() {
            throw new RuntimeException("hoge");
        }
    }
}

