/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.IOException;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.OutputStreamUtil;

public class OutputStreamUtilTest
extends TestCase {
    public void testClose() throws Exception {
        NotifyOutputStream out = new NotifyOutputStream();
        OutputStreamUtil.close((OutputStream)out);
        OutputStreamUtilTest.assertEquals((String)"closed", (String)out.getNotify());
    }

    public void testCloseNull() throws Exception {
        OutputStreamUtil.close((OutputStream)null);
        OutputStreamUtilTest.assertTrue((boolean)true);
    }

    public void testClose_throwIOException() throws Exception {
        IOExceptionOccurOutputStream out = new IOExceptionOccurOutputStream();
        try {
            OutputStreamUtil.close((OutputStream)out);
            OutputStreamUtilTest.fail();
        }
        catch (IORuntimeException e) {
            OutputStreamUtilTest.assertTrue((boolean)true);
        }
    }

    private static class IOExceptionOccurOutputStream
    extends OutputStream {
        private IOExceptionOccurOutputStream() {
        }

        public void write(int arg0) throws IOException {
        }

        public void close() throws IOException {
            throw new IOException();
        }
    }

    private static class NotifyOutputStream
    extends OutputStream {
        private String notify_;

        private NotifyOutputStream() {
        }

        public void write(int arg0) throws IOException {
        }

        public void close() throws IOException {
            super.close();
            this.notify_ = "closed";
        }

        public String getNotify() {
            return this.notify_;
        }
    }
}

