/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.text.DecimalFormatSymbols;
import java.util.Locale;
import junit.framework.TestCase;
import org.seasar.framework.util.NumberConversionUtil;

public class NumberConversionUtilTest
extends TestCase {
    public void testConvertNumber_byte() throws Exception {
        NumberConversionUtilTest.assertEquals((Object)new Byte("1"), (Object)NumberConversionUtil.convertNumber((Class)Byte.class, (Object)"1"));
    }

    public void testConvertNumber_primitiveWrapper() throws Exception {
        NumberConversionUtilTest.assertEquals((Object)new Byte("1"), (Object)NumberConversionUtil.convertPrimitiveWrapper(Byte.TYPE, (Object)"1"));
        NumberConversionUtilTest.assertEquals((Object)new Byte("0"), (Object)NumberConversionUtil.convertPrimitiveWrapper(Byte.TYPE, null));
    }

    public void testFindFractionDelimeter() throws Exception {
        String delim = NumberConversionUtil.findDecimalSeparator((Locale)Locale.JAPAN);
        NumberConversionUtilTest.assertEquals((String)".", (String)delim);
    }

    public void testFindFractionDelimeter2() throws Exception {
        String delim = NumberConversionUtil.findDecimalSeparator((Locale)Locale.FRANCE);
        NumberConversionUtilTest.assertEquals((String)",", (String)delim);
    }

    public void testFindFractionDelimeter3() throws Exception {
        String delim = NumberConversionUtil.findDecimalSeparator(null);
        char c = new DecimalFormatSymbols(Locale.getDefault()).getDecimalSeparator();
        NumberConversionUtilTest.assertEquals((String)Character.toString(c), (String)delim);
    }

    public void testFindIntegerDelimeter() throws Exception {
        String delim = NumberConversionUtil.findGroupingSeparator((Locale)Locale.JAPAN);
        NumberConversionUtilTest.assertEquals((String)",", (String)delim);
    }

    public void testFindIntegerDelimeter2() throws Exception {
        String delim = NumberConversionUtil.findGroupingSeparator((Locale)Locale.GERMANY);
        NumberConversionUtilTest.assertEquals((String)".", (String)delim);
    }

    public void testFindIntegerDelimeter3() throws Exception {
        String delim = NumberConversionUtil.findGroupingSeparator(null);
        char c = new DecimalFormatSymbols(Locale.getDefault()).getGroupingSeparator();
        NumberConversionUtilTest.assertEquals((String)Character.toString(c), (String)delim);
    }

    public void testRemoveDelimeter() throws Exception {
        NumberConversionUtilTest.assertEquals((String)"1000000.234", (String)NumberConversionUtil.removeDelimeter((String)"1,000,000.234", (Locale)Locale.JAPAN));
    }
}

