/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.seasar.framework.util.ModifierUtil;

public class ModifierUtilTest
extends TestCase {
    public void testIsPublic() throws Exception {
        Field f = Hoge.class.getDeclaredField("s");
        ModifierUtilTest.assertTrue((boolean)ModifierUtil.isPublicStaticFinalField((Field)f));
        Method m = Hoge.class.getDeclaredMethod("hoge", new Class[0]);
        ModifierUtilTest.assertTrue((boolean)ModifierUtil.isPublic((Method)m));
    }

    public void testIsInstanceField() throws Exception {
        Field f = Hoge.class.getDeclaredField("aaa");
        ModifierUtilTest.assertTrue((boolean)ModifierUtil.isInstanceField((Field)f));
        f = Hoge.class.getDeclaredField("s");
        ModifierUtilTest.assertFalse((boolean)ModifierUtil.isInstanceField((Field)f));
    }

    public void testIsTransient() throws Exception {
        Field f = Hoge.class.getDeclaredField("bbb");
        ModifierUtilTest.assertTrue((boolean)ModifierUtil.isTransient((Field)f));
        f = Hoge.class.getDeclaredField("s");
        ModifierUtilTest.assertFalse((boolean)ModifierUtil.isTransient((Field)f));
    }

    public void testIsAbstract() throws Exception {
        ModifierUtilTest.assertTrue((boolean)ModifierUtil.isAbstract((Class)Map.class));
        ModifierUtilTest.assertFalse((boolean)ModifierUtil.isAbstract((Class)HashMap.class));
    }

    public static class Hoge {
        public static final String s = null;
        public String aaa;
        public transient String bbb;

        public static String hoge() {
            return "aaa";
        }
    }
}

