/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.net.URLConnection;
import junit.framework.TestCase;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.MimeTypeUtil;
import org.seasar.framework.util.ResourceUtil;

public class MimeTypeUtilTest
extends TestCase {
    public void testGetFromStream() throws Exception {
        String path = ClassUtil.getPackageName(((Object)((Object)this)).getClass()).replaceAll("\\.", "/") + "/aaa.html";
        String contentType = MimeTypeUtil.guessContentType((String)path);
        MimeTypeUtilTest.assertEquals((String)"text/html", (String)contentType);
    }

    public void testGetFromStream_gif() throws Exception {
        String path = ClassUtil.getPackageName(((Object)((Object)this)).getClass()).replaceAll("\\.", "/") + "/ccc.gif";
        String contentType = MimeTypeUtil.guessContentType((String)path);
        MimeTypeUtilTest.assertEquals((String)"image/gif", (String)contentType);
    }

    public void testGetFromPath() throws Exception {
        String path = ClassUtil.getPackageName(((Object)((Object)this)).getClass()).replaceAll("\\.", "/") + "/bbb.html";
        String s = URLConnection.guessContentTypeFromStream(ResourceUtil.getResourceAsStream((String)path));
        MimeTypeUtilTest.assertNull((Object)s);
        String contentType = MimeTypeUtil.guessContentType((String)path);
        MimeTypeUtilTest.assertEquals((String)"text/html", (String)contentType);
    }
}

