/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.lang.reflect.Method;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.MethodUtil;

public class MethodUtilTest
extends TestCase {
    public void testIsEqualsMethod() {
        Method equalsMethod = ClassUtil.getMethod(((Object)((Object)this)).getClass(), (String)"equals", (Class[])new Class[]{Object.class});
        MethodUtilTest.assertTrue((String)"1", (boolean)MethodUtil.isEqualsMethod((Method)equalsMethod));
        Method hashCodeMethod = ClassUtil.getMethod(((Object)((Object)this)).getClass(), (String)"hashCode", (Class[])new Class[0]);
        MethodUtilTest.assertFalse((String)"2", (boolean)MethodUtil.isEqualsMethod((Method)hashCodeMethod));
    }

    public void testIsHashCodeMethod() {
        Method equalsMethod = ClassUtil.getMethod(((Object)((Object)this)).getClass(), (String)"equals", (Class[])new Class[]{Object.class});
        MethodUtilTest.assertFalse((String)"1", (boolean)MethodUtil.isHashCodeMethod((Method)equalsMethod));
        Method hashCodeMethod = ClassUtil.getMethod(((Object)((Object)this)).getClass(), (String)"hashCode", (Class[])new Class[0]);
        MethodUtilTest.assertTrue((String)"2", (boolean)MethodUtil.isHashCodeMethod((Method)hashCodeMethod));
    }

    public void testIsToStringMethod() {
        Method toStringMethod = ClassUtil.getMethod(((Object)((Object)this)).getClass(), (String)"toString", (Class[])new Class[0]);
        MethodUtilTest.assertTrue((String)"1", (boolean)MethodUtil.isToStringMethod((Method)toStringMethod));
        Method hashCodeMethod = ClassUtil.getMethod(((Object)((Object)this)).getClass(), (String)"hashCode", (Class[])new Class[0]);
        MethodUtilTest.assertFalse((String)"2", (boolean)MethodUtil.isToStringMethod((Method)hashCodeMethod));
    }

    public void testIsBridgeMethod() throws Exception {
        Method method = Foo.class.getMethod("foo", null);
        MethodUtilTest.assertFalse((boolean)MethodUtil.isBridgeMethod((Method)method));
    }

    public void testIsSyntheticMethod() throws Exception {
        Method method = Foo.class.getMethod("foo", null);
        MethodUtilTest.assertFalse((boolean)MethodUtil.isSyntheticMethod((Method)method));
    }

    public void testIsDefaultMethod() throws Exception {
        Method method = Foo.class.getMethod("foo", null);
        MethodUtilTest.assertFalse((boolean)MethodUtil.isDefaultMethod((Method)method));
    }

    public void testGetElementTypeOfListFromParameterType() throws Exception {
        MethodUtilTest.assertNull((Object)MethodUtil.getElementTypeOfListFromParameterType((Method)Baz.class.getMethod("hoge", List.class), (int)0));
        MethodUtilTest.assertNull((Object)MethodUtil.getElementTypeOfListFromParameterType((Method)Baz.class.getMethod("hoge", List.class, List.class), (int)0));
        MethodUtilTest.assertNull((Object)MethodUtil.getElementTypeOfListFromParameterType((Method)Baz.class.getMethod("hoge", List.class, List.class), (int)1));
    }

    public void testGetElementTypeOfListFromReturnType() throws Exception {
        MethodUtilTest.assertNull((Object)MethodUtil.getElementTypeOfListFromReturnType((Method)Baz.class.getMethod("hoge", List.class)));
    }

    public static interface Baz {
        public List hoge(List var1);

        public void hoge(List var1, List var2);
    }

    public static class Foo {
        public void foo() {
        }
    }
}

