/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.lang.reflect.Field;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.framework.exception.SIllegalArgumentException;
import org.seasar.framework.util.FieldUtil;

public class FieldUtilTest
extends TestCase {
    public Object objectField;
    public int intField;
    public String stringField;
    public static final int INT_DATA = 987654321;
    public static final String STRING_DATA = "Hello World!";

    public void testGet() {
        try {
            Field field = ((Object)((Object)this)).getClass().getField("objectField");
            Integer testData = new Integer(123);
            FieldUtil.set((Field)field, (Object)((Object)this), (Object)testData);
            FieldUtilTest.assertEquals((String)"1", (Object)testData, (Object)FieldUtil.get((Field)field, (Object)((Object)this)));
        }
        catch (SecurityException e) {
            FieldUtilTest.fail();
        }
        catch (NoSuchFieldException e) {
            FieldUtilTest.fail();
        }
    }

    public void testGetIntField() {
        try {
            Field field = ((Object)((Object)this)).getClass().getField("intField");
            int testData = 1234567890;
            FieldUtil.set((Field)field, (Object)((Object)this), (Object)new Integer(testData));
            FieldUtilTest.assertEquals((String)"1", (int)testData, (int)FieldUtil.getInt((Field)field, (Object)((Object)this)));
        }
        catch (SecurityException e) {
            FieldUtilTest.fail();
        }
        catch (NoSuchFieldException e) {
            FieldUtilTest.fail();
        }
    }

    public void testGetIntFieldObject() {
        try {
            Field field = ((Object)((Object)this)).getClass().getField("INT_DATA");
            FieldUtilTest.assertEquals((String)"1", (int)987654321, (int)FieldUtil.getInt((Field)field));
        }
        catch (SecurityException e) {
            FieldUtilTest.fail();
        }
        catch (NoSuchFieldException e) {
            FieldUtilTest.fail();
        }
    }

    public void testGetStringField() {
        try {
            Field field = ((Object)((Object)this)).getClass().getField("stringField");
            String testData = STRING_DATA;
            FieldUtil.set((Field)field, (Object)((Object)this), (Object)testData);
            FieldUtilTest.assertEquals((String)"1", (String)testData, (String)FieldUtil.getString((Field)field, (Object)((Object)this)));
        }
        catch (SecurityException e) {
            FieldUtilTest.fail();
        }
        catch (NoSuchFieldException e) {
            FieldUtilTest.fail();
        }
    }

    public void testGetStringFieldObject() {
        try {
            Field field = ((Object)((Object)this)).getClass().getField("STRING_DATA");
            FieldUtilTest.assertEquals((String)"1", (String)STRING_DATA, (String)FieldUtil.getString((Field)field));
        }
        catch (SecurityException e) {
            FieldUtilTest.fail();
        }
        catch (NoSuchFieldException e) {
            FieldUtilTest.fail();
        }
    }

    public void testSet() throws Exception {
        Field field = ((Object)((Object)this)).getClass().getField("intField");
        try {
            FieldUtil.set((Field)field, (Object)((Object)this), (Object)"abc");
            FieldUtilTest.fail();
        }
        catch (SIllegalArgumentException e) {
            System.out.println((Object)e);
        }
    }

    public void testGetElementTypeOfListFromFieldType() throws Exception {
        FieldUtilTest.assertNull((Object)FieldUtil.getElementTypeOfListFromFieldType((Field)Baz.class.getField("list")));
    }

    public static class Baz {
        public List list;
    }
}

