/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import [[Ljava.lang.String;;
import java.lang.reflect.Field;
import junit.framework.TestCase;
import org.seasar.framework.exception.NoSuchConstructorRuntimeException;
import org.seasar.framework.exception.NoSuchFieldRuntimeException;
import org.seasar.framework.util.ClassUtil;

public class ClassUtilTest
extends TestCase {
    public static final String HOGE = "hoge";

    public void testGetPrimitiveClass() {
        ClassUtilTest.assertEquals((String)"1", Integer.TYPE, (Object)ClassUtil.getPrimitiveClass((Class)Integer.class));
        ClassUtilTest.assertEquals((String)"2", null, (Object)ClassUtil.getPrimitiveClass((Class)String.class));
        ClassUtilTest.assertEquals((String)"3", Byte.TYPE, (Object)ClassUtil.getPrimitiveClass((Class)Byte.class));
    }

    public void testGetPrimitiveClassIfWrapper() {
        ClassUtilTest.assertEquals((String)"1", Integer.TYPE, (Object)ClassUtil.getPrimitiveClassIfWrapper((Class)Integer.class));
        ClassUtilTest.assertEquals((String)"2", (Object)String.class, (Object)ClassUtil.getPrimitiveClassIfWrapper((Class)String.class));
        ClassUtilTest.assertEquals((String)"3", Byte.TYPE, (Object)ClassUtil.getPrimitiveClassIfWrapper((Class)Byte.class));
    }

    public void testGetWrapperClass() {
        ClassUtilTest.assertEquals((String)"1", (Object)Integer.class, (Object)ClassUtil.getWrapperClass(Integer.TYPE));
        ClassUtilTest.assertEquals((String)"2", null, (Object)ClassUtil.getWrapperClass((Class)String.class));
        ClassUtilTest.assertEquals((String)"3", (Object)Byte.class, (Object)ClassUtil.getWrapperClass(Byte.TYPE));
    }

    public void testGetWrapperClassIfWrapper() {
        ClassUtilTest.assertEquals((String)"1", (Object)Integer.class, (Object)ClassUtil.getWrapperClassIfPrimitive(Integer.TYPE));
        ClassUtilTest.assertEquals((String)"2", (Object)String.class, (Object)ClassUtil.getWrapperClassIfPrimitive((Class)String.class));
        ClassUtilTest.assertEquals((String)"3", (Object)Byte.class, (Object)ClassUtil.getWrapperClassIfPrimitive(Byte.TYPE));
    }

    public void testIsAssignableFrom() {
        ClassUtilTest.assertEquals((String)"1", (boolean)true, (boolean)ClassUtil.isAssignableFrom((Class)Number.class, (Class)Integer.class));
        ClassUtilTest.assertEquals((String)"2", (boolean)false, (boolean)ClassUtil.isAssignableFrom((Class)Integer.class, (Class)Number.class));
        ClassUtilTest.assertEquals((String)"3", (boolean)true, (boolean)ClassUtil.isAssignableFrom(Integer.TYPE, (Class)Integer.class));
    }

    public void testGetPackageName() {
        ClassUtilTest.assertEquals((String)"1", (String)"org.seasar.framework.util", (String)ClassUtil.getPackageName(((Object)((Object)this)).getClass()));
    }

    public void testGetShortClassName() {
        ClassUtilTest.assertEquals((String)"1", (String)"ClassUtilTest", (String)ClassUtil.getShortClassName(((Object)((Object)this)).getClass()));
    }

    public void testGetConstructor() {
        try {
            ClassUtil.getConstructor((Class)ClassUtilTest.class, (Class[])new Class[]{Integer.class});
            ClassUtilTest.fail((String)"1");
        }
        catch (NoSuchConstructorRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public void testGetField() {
        try {
            ClassUtil.getField(((Object)((Object)this)).getClass(), (String)"aaa");
        }
        catch (NoSuchFieldRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    public void testGetSimpleClassName() {
        ClassUtilTest.assertEquals((String)"1", (String)"int", (String)ClassUtil.getSimpleClassName(Integer.TYPE));
        ClassUtilTest.assertEquals((String)"2", (String)"java.lang.String", (String)ClassUtil.getSimpleClassName((Class)String.class));
        ClassUtilTest.assertEquals((String)"3", (String)"int[]", (String)ClassUtil.getSimpleClassName((Class)[I.class));
        ClassUtilTest.assertEquals((String)"4", (String)"java.lang.String[][]", (String)ClassUtil.getSimpleClassName((Class)String;.class));
    }

    public void testConcatName() {
        ClassUtilTest.assertEquals((String)"aaa.bbb", (String)ClassUtil.concatName((String)"aaa", (String)"bbb"));
        ClassUtilTest.assertEquals((String)"aaa", (String)ClassUtil.concatName((String)"aaa", null));
        ClassUtilTest.assertEquals((String)"aaa", (String)ClassUtil.concatName((String)"aaa", (String)""));
        ClassUtilTest.assertEquals((String)"bbb", (String)ClassUtil.concatName(null, (String)"bbb"));
        ClassUtilTest.assertEquals((String)"bbb", (String)ClassUtil.concatName((String)"", (String)"bbb"));
        ClassUtilTest.assertEquals((String)"bbb", (String)ClassUtil.concatName((String)"", (String)"bbb"));
        ClassUtilTest.assertNull((Object)ClassUtil.concatName(null, null));
        ClassUtilTest.assertNull((Object)ClassUtil.concatName(null, (String)""));
        ClassUtilTest.assertNull((Object)ClassUtil.concatName((String)"", null));
        ClassUtilTest.assertNull((Object)ClassUtil.concatName((String)"", (String)""));
    }

    public void testGetResourcePath() {
        ClassUtilTest.assertEquals((String)"1", (String)"org/seasar/framework/util/ClassUtilTest.class", (String)ClassUtil.getResourcePath(((Object)((Object)this)).getClass()));
    }

    public void testSplitPackageAndShortClassName() {
        String[] ret = ClassUtil.splitPackageAndShortClassName((String)"aaa.Hoge");
        ClassUtilTest.assertEquals((String)"aaa", (String)ret[0]);
        ClassUtilTest.assertEquals((String)"Hoge", (String)ret[1]);
        ret = ClassUtil.splitPackageAndShortClassName((String)"Hoge");
        ClassUtilTest.assertNull((Object)ret[0]);
        ClassUtilTest.assertEquals((String)"Hoge", (String)ret[1]);
    }

    public void testConvertClass() {
        ClassUtilTest.assertEquals(Integer.TYPE, (Object)ClassUtil.convertClass((String)"int"));
        ClassUtilTest.assertEquals((Object)String.class, (Object)ClassUtil.convertClass((String)"java.lang.String"));
    }

    public void testGetDeclaredFields() throws Exception {
        Field[] fields = ClassUtil.getDeclaredFields((Class)TestClass.class);
        ClassUtilTest.assertEquals((int)5, (int)fields.length);
        ClassUtilTest.assertEquals((String)"aaa", (String)fields[0].getName());
        ClassUtilTest.assertEquals((String)"bbb", (String)fields[1].getName());
        ClassUtilTest.assertEquals((String)"ccc", (String)fields[2].getName());
        ClassUtilTest.assertEquals((String)"ddd", (String)fields[3].getName());
        ClassUtilTest.assertEquals((String)"eee", (String)fields[4].getName());
    }

    public static class TestClass {
        int aaa;
        int bbb;
        int ccc;
        int ddd;
        int eee;
    }
}

