/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.mock.sql;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import junit.framework.TestCase;
import org.seasar.framework.mock.sql.MockResultSet;
import org.seasar.framework.util.ArrayMap;

public class MockResultSetTest
extends TestCase {
    public void testAddAndGetRowData() {
        MockResultSet rs = new MockResultSet();
        ArrayMap rowData = new ArrayMap();
        rowData.put((Object)"id", (Object)new Integer(1));
        rs.addRowData(rowData);
        MockResultSetTest.assertSame((Object)rowData, (Object)rs.getRowData(1));
    }

    public void testGetColumnData() throws Exception {
        MockResultSet rs = new MockResultSet();
        ArrayMap rowData = new ArrayMap();
        Integer value = new Integer(1);
        rowData.put((Object)"id", (Object)value);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.next());
        MockResultSetTest.assertEquals((Object)value, (Object)rs.getColumnData(1));
        MockResultSetTest.assertEquals((Object)value, (Object)rs.getColumnData("id"));
    }

    public void testNext() throws Exception {
        MockResultSet rs = new MockResultSet();
        ArrayMap rowData = new ArrayMap();
        Integer value = new Integer(1);
        rowData.put((Object)"id", (Object)value);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.next());
        MockResultSetTest.assertEquals((int)1, (int)rs.getRow());
        MockResultSetTest.assertFalse((boolean)rs.next());
        MockResultSetTest.assertEquals((int)2, (int)rs.getRow());
        MockResultSetTest.assertFalse((boolean)rs.next());
        MockResultSetTest.assertEquals((int)2, (int)rs.getRow());
    }

    public void testPrevious() throws Exception {
        MockResultSet rs = new MockResultSet();
        try {
            rs.previous();
            MockResultSetTest.fail();
        }
        catch (SQLException e) {
            System.out.println(e);
        }
        rs.setType(1004);
        ArrayMap rowData = new ArrayMap();
        Integer value = new Integer(1);
        rowData.put((Object)"id", (Object)value);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.next());
        MockResultSetTest.assertFalse((boolean)rs.next());
        MockResultSetTest.assertTrue((boolean)rs.previous());
        MockResultSetTest.assertEquals((int)1, (int)rs.getRow());
        MockResultSetTest.assertFalse((boolean)rs.previous());
        MockResultSetTest.assertEquals((int)0, (int)rs.getRow());
    }

    public void testGetBigDecimal() throws Exception {
        MockResultSet rs = new MockResultSet();
        ArrayMap rowData = new ArrayMap();
        BigDecimal value = new BigDecimal(1.0);
        rowData.put((Object)"id", (Object)value);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.next());
        MockResultSetTest.assertEquals((Object)value, (Object)rs.getBigDecimal(1));
        MockResultSetTest.assertEquals((Object)value, (Object)rs.getBigDecimal("id"));
        BigDecimal value2 = rs.getBigDecimal(1, 2);
        MockResultSetTest.assertEquals((int)2, (int)value2.scale());
        value2 = rs.getBigDecimal("id", 2);
        MockResultSetTest.assertEquals((int)2, (int)value2.scale());
    }

    public void testGetBoolean() throws Exception {
        MockResultSet rs = new MockResultSet();
        ArrayMap rowData = new ArrayMap();
        Boolean value = Boolean.TRUE;
        rowData.put((Object)"hoge", (Object)value);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.next());
        MockResultSetTest.assertTrue((boolean)rs.getBoolean(1));
        MockResultSetTest.assertTrue((boolean)rs.getBoolean("hoge"));
    }

    public void testGetByte() throws Exception {
        MockResultSet rs = new MockResultSet();
        ArrayMap rowData = new ArrayMap();
        Byte value = new Byte(1);
        rowData.put((Object)"hoge", (Object)value);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.next());
        MockResultSetTest.assertEquals((byte)1, (byte)rs.getByte(1));
        MockResultSetTest.assertEquals((byte)1, (byte)rs.getByte("hoge"));
    }

    public void testGetBytes() throws Exception {
        MockResultSet rs = new MockResultSet();
        ArrayMap rowData = new ArrayMap();
        byte[] value = new byte[]{};
        rowData.put((Object)"hoge", (Object)value);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.next());
        MockResultSetTest.assertSame((Object)value, (Object)rs.getBytes(1));
        MockResultSetTest.assertSame((Object)value, (Object)rs.getBytes("hoge"));
    }

    public void testGetDate() throws Exception {
        MockResultSet rs = new MockResultSet();
        ArrayMap rowData = new ArrayMap();
        Date value = new Date(0L);
        rowData.put((Object)"hoge", (Object)value);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.next());
        MockResultSetTest.assertSame((Object)value, (Object)rs.getDate(1));
        MockResultSetTest.assertSame((Object)value, (Object)rs.getDate("hoge"));
    }

    public void testGetDouble() throws Exception {
        MockResultSet rs = new MockResultSet();
        ArrayMap rowData = new ArrayMap();
        Double value = new Double(0.0);
        rowData.put((Object)"hoge", (Object)value);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.next());
        MockResultSetTest.assertEquals((double)value, (double)rs.getDouble(1), (double)0.0);
        MockResultSetTest.assertEquals((double)value, (double)rs.getDouble("hoge"), (double)0.0);
    }

    public void testGetFloat() throws Exception {
        MockResultSet rs = new MockResultSet();
        ArrayMap rowData = new ArrayMap();
        Float value = new Float(0.0f);
        rowData.put((Object)"hoge", (Object)value);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.next());
        MockResultSetTest.assertEquals((float)value.floatValue(), (float)rs.getFloat(1), (float)0.0f);
        MockResultSetTest.assertEquals((float)value.floatValue(), (float)rs.getFloat("hoge"), (float)0.0f);
    }

    public void testGetInt() throws Exception {
        MockResultSet rs = new MockResultSet();
        ArrayMap rowData = new ArrayMap();
        Integer value = new Integer(0);
        rowData.put((Object)"hoge", (Object)value);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.next());
        MockResultSetTest.assertEquals((int)value, (int)rs.getInt(1));
        MockResultSetTest.assertEquals((int)value, (int)rs.getInt("hoge"));
    }

    public void testGetLong() throws Exception {
        MockResultSet rs = new MockResultSet();
        ArrayMap rowData = new ArrayMap();
        Long value = new Long(0L);
        rowData.put((Object)"hoge", (Object)value);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.next());
        MockResultSetTest.assertEquals((long)value, (long)rs.getLong(1));
        MockResultSetTest.assertEquals((long)value, (long)rs.getLong("hoge"));
    }

    public void testGetObject() throws Exception {
        MockResultSet rs = new MockResultSet();
        ArrayMap rowData = new ArrayMap();
        Object value = new Object();
        rowData.put((Object)"hoge", value);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.next());
        MockResultSetTest.assertSame((Object)value, (Object)rs.getObject(1));
        MockResultSetTest.assertSame((Object)value, (Object)rs.getObject("hoge"));
    }

    public void testGetShort() throws Exception {
        MockResultSet rs = new MockResultSet();
        ArrayMap rowData = new ArrayMap();
        Short value = new Short(0);
        rowData.put((Object)"hoge", (Object)value);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.next());
        MockResultSetTest.assertEquals((short)value, (short)rs.getShort(1));
        MockResultSetTest.assertEquals((short)value, (short)rs.getShort("hoge"));
    }

    public void testGetString() throws Exception {
        MockResultSet rs = new MockResultSet();
        ArrayMap rowData = new ArrayMap();
        String value = "aaa";
        rowData.put((Object)"hoge", (Object)value);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.next());
        MockResultSetTest.assertEquals((String)value, (String)rs.getString(1));
        MockResultSetTest.assertEquals((String)value, (String)rs.getString("hoge"));
    }

    public void testGetTime() throws Exception {
        MockResultSet rs = new MockResultSet();
        ArrayMap rowData = new ArrayMap();
        Time value = new Time(0L);
        rowData.put((Object)"hoge", (Object)value);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.next());
        MockResultSetTest.assertEquals((Object)value, (Object)rs.getTime(1));
        MockResultSetTest.assertEquals((Object)value, (Object)rs.getTime("hoge"));
    }

    public void testGetTimestamp() throws Exception {
        MockResultSet rs = new MockResultSet();
        ArrayMap rowData = new ArrayMap();
        Timestamp value = new Timestamp(0L);
        rowData.put((Object)"hoge", (Object)value);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.next());
        MockResultSetTest.assertEquals((Object)value, (Object)rs.getTimestamp(1));
        MockResultSetTest.assertEquals((Object)value, (Object)rs.getTimestamp("hoge"));
    }

    public void testIsAfterLast() throws Exception {
        MockResultSet rs = new MockResultSet();
        ArrayMap rowData = new ArrayMap();
        Timestamp value = new Timestamp(0L);
        rowData.put((Object)"hoge", (Object)value);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.next());
        MockResultSetTest.assertFalse((boolean)rs.isAfterLast());
        MockResultSetTest.assertFalse((boolean)rs.next());
        MockResultSetTest.assertTrue((boolean)rs.isAfterLast());
    }

    public void testIsBeforeFirst() throws Exception {
        MockResultSet rs = new MockResultSet();
        ArrayMap rowData = new ArrayMap();
        Timestamp value = new Timestamp(0L);
        rowData.put((Object)"hoge", (Object)value);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.isBeforeFirst());
        MockResultSetTest.assertTrue((boolean)rs.next());
        MockResultSetTest.assertFalse((boolean)rs.isBeforeFirst());
    }

    public void testIsFirst() throws Exception {
        MockResultSet rs = new MockResultSet();
        ArrayMap rowData = new ArrayMap();
        Timestamp value = new Timestamp(0L);
        rowData.put((Object)"hoge", (Object)value);
        rs.addRowData(rowData);
        MockResultSetTest.assertFalse((boolean)rs.isFirst());
        MockResultSetTest.assertTrue((boolean)rs.next());
        MockResultSetTest.assertTrue((boolean)rs.isFirst());
    }

    public void testIsLast() throws Exception {
        MockResultSet rs = new MockResultSet();
        ArrayMap rowData = new ArrayMap();
        Timestamp value = new Timestamp(0L);
        rowData.put((Object)"hoge", (Object)value);
        rs.addRowData(rowData);
        MockResultSetTest.assertFalse((boolean)rs.isLast());
        MockResultSetTest.assertTrue((boolean)rs.next());
        MockResultSetTest.assertTrue((boolean)rs.isLast());
    }

    public void testLast() throws Exception {
        MockResultSet rs = new MockResultSet();
        rs.setType(1004);
        ArrayMap rowData = new ArrayMap();
        Timestamp value = new Timestamp(0L);
        rowData.put((Object)"hoge", (Object)value);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.last());
        MockResultSetTest.assertTrue((boolean)rs.isLast());
    }

    public void testFirst() throws Exception {
        MockResultSet rs = new MockResultSet();
        rs.setType(1004);
        ArrayMap rowData = new ArrayMap();
        Timestamp value = new Timestamp(0L);
        rowData.put((Object)"hoge", (Object)value);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.first());
        MockResultSetTest.assertTrue((boolean)rs.isFirst());
    }

    public void testAbsolute() throws Exception {
        MockResultSet rs = new MockResultSet();
        rs.setType(1004);
        ArrayMap rowData = new ArrayMap();
        Timestamp value = new Timestamp(0L);
        rowData.put((Object)"hoge", (Object)value);
        rs.addRowData(rowData);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.absolute(1));
        MockResultSetTest.assertEquals((int)1, (int)rs.getRow());
        MockResultSetTest.assertTrue((boolean)rs.absolute(2));
        MockResultSetTest.assertEquals((int)2, (int)rs.getRow());
        MockResultSetTest.assertFalse((boolean)rs.absolute(0));
        MockResultSetTest.assertEquals((int)2, (int)rs.getRow());
        MockResultSetTest.assertFalse((boolean)rs.absolute(3));
        MockResultSetTest.assertEquals((int)2, (int)rs.getRow());
    }

    public void testRelative() throws Exception {
        MockResultSet rs = new MockResultSet();
        rs.setType(1004);
        ArrayMap rowData = new ArrayMap();
        Timestamp value = new Timestamp(0L);
        rowData.put((Object)"hoge", (Object)value);
        rs.addRowData(rowData);
        rs.addRowData(rowData);
        MockResultSetTest.assertTrue((boolean)rs.relative(2));
        MockResultSetTest.assertEquals((int)2, (int)rs.getRow());
        MockResultSetTest.assertTrue((boolean)rs.relative(-1));
        MockResultSetTest.assertEquals((int)1, (int)rs.getRow());
        MockResultSetTest.assertTrue((boolean)rs.relative(1));
        MockResultSetTest.assertEquals((int)2, (int)rs.getRow());
        MockResultSetTest.assertFalse((boolean)rs.relative(1));
        MockResultSetTest.assertEquals((int)2, (int)rs.getRow());
        MockResultSetTest.assertFalse((boolean)rs.relative(-2));
        MockResultSetTest.assertEquals((int)2, (int)rs.getRow());
    }
}

