/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.hotdeploy;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.seasar.framework.container.hotdeploy.HotdeployBehavior;
import org.seasar.framework.container.hotdeploy.HotdeployClassLoader;
import org.seasar.framework.container.hotdeploy.HotdeployUtil;
import org.seasar.framework.container.impl.S2ContainerBehavior;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.convention.impl.NamingConventionImpl;
import org.seasar.framework.unit.S2FrameworkTestCase;

public class HotdeployUtilTest
extends S2FrameworkTestCase {
    protected void tearDown() {
        S2ContainerBehavior.setProvider((S2ContainerBehavior.Provider)new S2ContainerBehavior.DefaultProvider());
    }

    public void testIsHotdeploy() throws Exception {
        HotdeployUtilTest.assertFalse((boolean)HotdeployUtil.isHotdeploy());
        S2ContainerBehavior.setProvider((S2ContainerBehavior.Provider)new HotdeployBehavior());
        HotdeployUtilTest.assertTrue((boolean)HotdeployUtil.isHotdeploy());
    }

    public void testRebuildValue_simpleType() throws Exception {
        HotdeployUtilTest.assertEquals((Object)"111", (Object)HotdeployUtil.rebuildValueInternal((Object)"111"));
    }

    public void testRebuildValue_array() throws Exception {
        String[] array = (String[])HotdeployUtil.rebuildValueInternal((Object)new String[]{"aaa", "bbb"});
        HotdeployUtilTest.assertEquals((int)2, (int)array.length);
        HotdeployUtilTest.assertEquals((String)"aaa", (String)array[0]);
        HotdeployUtilTest.assertEquals((String)"bbb", (String)array[1]);
    }

    public void testRebuildValue_array_primitive() throws Exception {
        int[] array = (int[])HotdeployUtil.rebuildValueInternal((Object)new int[]{1, 2});
        HotdeployUtilTest.assertEquals((int)2, (int)array.length);
        HotdeployUtilTest.assertEquals((int)1, (int)array[0]);
        HotdeployUtilTest.assertEquals((int)2, (int)array[1]);
    }

    public void testRebuildValue_arrayList() throws Exception {
        ArrayList<String> src = new ArrayList<String>();
        src.add("aaa");
        src.add("bbb");
        ArrayList dest = (ArrayList)HotdeployUtil.rebuildValueInternal(src);
        HotdeployUtilTest.assertEquals((int)2, (int)dest.size());
        HotdeployUtilTest.assertEquals((Object)"aaa", dest.get(0));
        HotdeployUtilTest.assertEquals((Object)"bbb", dest.get(1));
    }

    public void testRebuildValue_collection() throws Exception {
        LinkedList<String> src = new LinkedList<String>();
        src.add("aaa");
        src.add("bbb");
        LinkedList dest = (LinkedList)HotdeployUtil.rebuildValueInternal(src);
        HotdeployUtilTest.assertEquals((int)2, (int)dest.size());
        HotdeployUtilTest.assertEquals((Object)"aaa", dest.get(0));
        HotdeployUtilTest.assertEquals((Object)"bbb", dest.get(1));
    }

    public void testRebuildValue_map() throws Exception {
        HashMap<String, String> src = new HashMap<String, String>();
        src.put("aaa", "111");
        HashMap dest = (HashMap)HotdeployUtil.rebuildValueInternal(src);
        HotdeployUtilTest.assertEquals((int)1, (int)dest.size());
        HotdeployUtilTest.assertEquals((Object)"111", dest.get("aaa"));
    }

    public void testRebuildValue_bean() throws Exception {
        Hoge src = new Hoge();
        src.setAaa("111");
        Hoge hoge = new Hoge();
        hoge.setAaa("222");
        src.setHoge(hoge);
        Hoge dest = (Hoge)HotdeployUtil.rebuildValueInternal((Object)src);
        HotdeployUtilTest.assertNotSame((Object)src, (Object)dest);
        HotdeployUtilTest.assertEquals((String)"111", (String)dest.getAaa());
        HotdeployUtilTest.assertNotNull((Object)dest.getHoge());
        HotdeployUtilTest.assertEquals((String)"222", (String)dest.getHoge().getAaa());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRebuildValue_arrayListWithPrimitiveA() throws Exception {
        boolean defaultDeployMode = this.isWarmDeploy();
        this.setWarmDeploy(true);
        try {
            ArrayList<String> list = new ArrayList<String>();
            list.add("aaa");
            list.add("bbb");
            list.add("ccc");
            List value = (List)HotdeployUtil.rebuildValue(list);
            HotdeployUtilTest.assertTrue((value.size() == 3 ? 1 : 0) != 0);
        }
        finally {
            this.setWarmDeploy(defaultDeployMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRebuildValue_arrayListWithDto() throws Exception {
        boolean defaultDeployMode = this.isWarmDeploy();
        this.setWarmDeploy(true);
        try {
            ArrayList<Hoge> list = new ArrayList<Hoge>();
            Hoge hoge = new Hoge();
            hoge.setAaa("A");
            list.add(hoge);
            hoge = new Hoge();
            hoge.setAaa("B");
            list.add(hoge);
            hoge = new Hoge();
            hoge.setAaa("C");
            list.add(hoge);
            List value = (List)HotdeployUtil.rebuildValue(list);
            HotdeployUtilTest.assertTrue((value.size() == 3 ? 1 : 0) != 0);
            Hoge h = (Hoge)value.get(0);
            HotdeployUtilTest.assertEquals((String)"A", (String)h.getAaa());
        }
        finally {
            this.setWarmDeploy(defaultDeployMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRebuildValue_arrayListWithDto2() throws Exception {
        boolean defaultDeployMode = this.isWarmDeploy();
        this.setWarmDeploy(true);
        try {
            ArrayList<Hoge> list = new ArrayList<Hoge>();
            Hoge hoge = new Hoge();
            hoge.setAaa("A");
            Foo f = new Foo();
            f.setNum(1);
            hoge.setFoo(f);
            list.add(hoge);
            hoge = new Hoge();
            hoge.setAaa("B");
            f = new Foo();
            f.setNum(2);
            hoge.setFoo(f);
            list.add(hoge);
            hoge = new Hoge();
            hoge.setAaa("C");
            f = new Foo();
            f.setNum(3);
            hoge.setFoo(f);
            list.add(hoge);
            List value = (List)HotdeployUtil.rebuildValue(list);
            HotdeployUtilTest.assertTrue((value.size() == 3 ? 1 : 0) != 0);
            Hoge h = (Hoge)value.get(0);
            HotdeployUtilTest.assertEquals((String)"A", (String)h.getAaa());
            HotdeployUtilTest.assertTrue((h.getFoo().getNum() == 1 ? 1 : 0) != 0);
        }
        finally {
            this.setWarmDeploy(defaultDeployMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPerformance() throws Exception {
        int n = 1000;
        Bar[] src = new Bar[n];
        for (int i = 0; i < n; ++i) {
            src[i] = new Bar();
        }
        ClassLoader originalLoader = Thread.currentThread().getContextClassLoader();
        NamingConventionImpl convention = new NamingConventionImpl();
        for (int i = 0; i < 5; ++i) {
            HotdeployClassLoader hotLoader = new HotdeployClassLoader(originalLoader, (NamingConvention)convention);
            Thread.currentThread().setContextClassLoader((ClassLoader)hotLoader);
            try {
                long t1 = System.currentTimeMillis();
                Bar[] dest = (Bar[])HotdeployUtil.rebuildValueInternal((Object)src);
                long t2 = System.currentTimeMillis();
                System.out.println("" + (t2 - t1) + "ms");
                HotdeployUtilTest.assertEquals((int)n, (int)dest.length);
                HotdeployUtilTest.assertEquals((String)"A", (String)dest[0].s01);
                continue;
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalLoader);
            }
        }
    }

    public void testDeserialize_simpleType() throws Exception {
        HotdeployUtilTest.assertEquals((Object)"111", (Object)HotdeployUtil.deserializeInternal((byte[])this.serialize("111")));
    }

    public void testDeserialize_array() throws Exception {
        String[] array = (String[])HotdeployUtil.deserializeInternal((byte[])this.serialize(new String[]{"aaa", "bbb"}));
        HotdeployUtilTest.assertEquals((int)2, (int)array.length);
        HotdeployUtilTest.assertEquals((String)"aaa", (String)array[0]);
        HotdeployUtilTest.assertEquals((String)"bbb", (String)array[1]);
    }

    public void testDeserialize_array_primitive() throws Exception {
        int[] array = (int[])HotdeployUtil.deserializeInternal((byte[])this.serialize(new int[]{1, 2}));
        HotdeployUtilTest.assertEquals((int)2, (int)array.length);
        HotdeployUtilTest.assertEquals((int)1, (int)array[0]);
        HotdeployUtilTest.assertEquals((int)2, (int)array[1]);
    }

    public void testDeserialize_arrayList() throws Exception {
        ArrayList<String> src = new ArrayList<String>();
        src.add("aaa");
        src.add("bbb");
        ArrayList dest = (ArrayList)HotdeployUtil.deserializeInternal((byte[])this.serialize(src));
        HotdeployUtilTest.assertEquals((int)2, (int)dest.size());
        HotdeployUtilTest.assertEquals((Object)"aaa", dest.get(0));
        HotdeployUtilTest.assertEquals((Object)"bbb", dest.get(1));
    }

    public void testDeserialize_collection() throws Exception {
        LinkedList<String> src = new LinkedList<String>();
        src.add("aaa");
        src.add("bbb");
        LinkedList dest = (LinkedList)HotdeployUtil.deserializeInternal((byte[])this.serialize(src));
        HotdeployUtilTest.assertEquals((int)2, (int)dest.size());
        HotdeployUtilTest.assertEquals((Object)"aaa", dest.get(0));
        HotdeployUtilTest.assertEquals((Object)"bbb", dest.get(1));
    }

    public void testDeserialize_map() throws Exception {
        HashMap<String, String> src = new HashMap<String, String>();
        src.put("aaa", "111");
        HashMap dest = (HashMap)HotdeployUtil.deserializeInternal((byte[])this.serialize(src));
        HotdeployUtilTest.assertEquals((int)1, (int)dest.size());
        HotdeployUtilTest.assertEquals((Object)"111", dest.get("aaa"));
    }

    public void testDeserialize_bean() throws Exception {
        Hoge src = new Hoge();
        src.setAaa("111");
        Hoge hoge = new Hoge();
        hoge.setAaa("222");
        src.setHoge(hoge);
        Hoge dest = (Hoge)HotdeployUtil.deserializeInternal((byte[])this.serialize(src));
        HotdeployUtilTest.assertNotSame((Object)src, (Object)dest);
        HotdeployUtilTest.assertEquals((String)"111", (String)dest.getAaa());
        HotdeployUtilTest.assertNotNull((Object)dest.getHoge());
        HotdeployUtilTest.assertEquals((String)"222", (String)dest.getHoge().getAaa());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeserialize_arrayListWithPrimitiveA() throws Exception {
        boolean defaultDeployMode = this.isWarmDeploy();
        this.setWarmDeploy(true);
        try {
            ArrayList<String> list = new ArrayList<String>();
            list.add("aaa");
            list.add("bbb");
            list.add("ccc");
            List value = (List)HotdeployUtil.deserializeInternal((byte[])this.serialize(list));
            HotdeployUtilTest.assertTrue((value.size() == 3 ? 1 : 0) != 0);
        }
        finally {
            this.setWarmDeploy(defaultDeployMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeserialize_arrayListWithDto() throws Exception {
        boolean defaultDeployMode = this.isWarmDeploy();
        this.setWarmDeploy(true);
        try {
            ArrayList<Hoge> list = new ArrayList<Hoge>();
            Hoge hoge = new Hoge();
            hoge.setAaa("A");
            list.add(hoge);
            hoge = new Hoge();
            hoge.setAaa("B");
            list.add(hoge);
            hoge = new Hoge();
            hoge.setAaa("C");
            list.add(hoge);
            List value = (List)HotdeployUtil.deserializeInternal((byte[])this.serialize(list));
            HotdeployUtilTest.assertTrue((value.size() == 3 ? 1 : 0) != 0);
            Hoge h = (Hoge)value.get(0);
            HotdeployUtilTest.assertEquals((String)"A", (String)h.getAaa());
        }
        finally {
            this.setWarmDeploy(defaultDeployMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeserialize_arrayListWithDto2() throws Exception {
        boolean defaultDeployMode = this.isWarmDeploy();
        this.setWarmDeploy(true);
        try {
            ArrayList<Hoge> list = new ArrayList<Hoge>();
            Hoge hoge = new Hoge();
            hoge.setAaa("A");
            Foo f = new Foo();
            f.setNum(1);
            hoge.setFoo(f);
            list.add(hoge);
            hoge = new Hoge();
            hoge.setAaa("B");
            f = new Foo();
            f.setNum(2);
            hoge.setFoo(f);
            list.add(hoge);
            hoge = new Hoge();
            hoge.setAaa("C");
            f = new Foo();
            f.setNum(3);
            hoge.setFoo(f);
            list.add(hoge);
            List value = (List)HotdeployUtil.deserializeInternal((byte[])this.serialize(list));
            HotdeployUtilTest.assertTrue((value.size() == 3 ? 1 : 0) != 0);
            Hoge h = (Hoge)value.get(0);
            HotdeployUtilTest.assertEquals((String)"A", (String)h.getAaa());
            HotdeployUtilTest.assertTrue((h.getFoo().getNum() == 1 ? 1 : 0) != 0);
        }
        finally {
            this.setWarmDeploy(defaultDeployMode);
        }
    }

    private byte[] serialize(Object o) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(o);
        oos.close();
        return baos.toByteArray();
    }

    public static class Bar
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public String s01 = "A";
        public String s02 = "B";
        public String s03 = "C";
        public String s04 = "D";
        public String s05 = "E";
        public String s06 = "F";
        public String s07 = "G";
        public String s08 = "H";
        public String s09 = "I";
        public String s10 = "J";
        public String s11 = "K";
        public String s12 = "L";
        public String s13 = "M";
        public String s14 = "N";
        public String s15 = "O";
        public String s16 = "P";
        public String s17 = "Q";
        public String s18 = "R";
        public String s19 = "S";
        public String s20 = "T";
    }

    public static class Foo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int num;

        public int getNum() {
            return this.num;
        }

        public void setNum(int num) {
            this.num = num;
        }
    }

    public static class Hoge
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String aaa;
        private Hoge hoge;
        private Foo foo;

        public Foo getFoo() {
            return this.foo;
        }

        public void setFoo(Foo foo) {
            this.foo = foo;
        }

        public String getAaa() {
            return this.aaa;
        }

        public void setAaa(String aaa) {
            this.aaa = aaa;
        }

        public Hoge getHoge() {
            return this.hoge;
        }

        public void setHoge(Hoge hoge) {
            this.hoge = hoge;
        }
    }
}

