/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.autoregister;

import junit.framework.TestCase;
import org.seasar.framework.container.autoregister.QualifiedAutoNaming;

public class QualifiedAutoNamingTest
extends TestCase {
    public void testDefineName() throws Exception {
        QualifiedAutoNaming naming = new QualifiedAutoNaming();
        naming.addIgnorePackagePrefix("foo.bar");
        naming.addIgnorePackagePrefix("hoge");
        naming.addIgnoreClassSuffix("Action");
        QualifiedAutoNamingTest.assertEquals((String)"1", (String)"hoge", (String)naming.defineName(null, "Hoge"));
        QualifiedAutoNamingTest.assertEquals((String)"2", (String)"fooHoge", (String)naming.defineName("foo", "Hoge"));
        QualifiedAutoNamingTest.assertEquals((String)"3", (String)"hoge", (String)naming.defineName("foo.bar", "Hoge"));
        QualifiedAutoNamingTest.assertEquals((String)"4", (String)"bazHoge", (String)naming.defineName("foo.bar.baz", "Hoge"));
        QualifiedAutoNamingTest.assertEquals((String)"5", (String)"hogeHoge", (String)naming.defineName("hoge.hoge", "Hoge"));
        QualifiedAutoNamingTest.assertEquals((String)"6", (String)"bazHoge", (String)naming.defineName("foo.bar.baz", "HogeActionImpl"));
    }

    public void testAddReplaceRule() throws Exception {
        QualifiedAutoNaming naming = new QualifiedAutoNaming();
        naming.addReplaceRule("(Ba[rz])+", "Hoge");
        QualifiedAutoNamingTest.assertEquals((String)"1", (String)"fooHoge", (String)naming.defineName(null, "FooBarBaz"));
    }

    public void testClearRule() throws Exception {
        QualifiedAutoNaming naming = new QualifiedAutoNaming();
        naming.clearReplaceRule();
        naming.addIgnorePackagePrefix("foo.bar");
        QualifiedAutoNamingTest.assertEquals((String)"1", (String)"bazHogeFoo4Impl", (String)naming.defineName("foo.bar.baz.hoge", "Foo4Impl"));
    }

    public void testNotDecapitalize() throws Exception {
        QualifiedAutoNaming naming = new QualifiedAutoNaming();
        naming.setDecapitalize(false);
        naming.addIgnorePackagePrefix("foo");
        QualifiedAutoNamingTest.assertEquals((String)"1", (String)"Hoge", (String)naming.defineName(null, "Hoge"));
        QualifiedAutoNamingTest.assertEquals((String)"2", (String)"Hoge", (String)naming.defineName("foo", "Hoge"));
        QualifiedAutoNamingTest.assertEquals((String)"3", (String)"BarHoge", (String)naming.defineName("foo.bar", "Hoge"));
    }
}

