/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import junit.framework.TestCase;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.Aspect;
import org.seasar.framework.aop.impl.AspectImpl;
import org.seasar.framework.aop.interceptors.ThrowsInterceptor;
import org.seasar.framework.aop.proxy.AopProxy;
import org.seasar.framework.beans.MethodNotFoundRuntimeException;

public class ThrowsInterceptorTest
extends TestCase {
    public void testHandleThrowable() throws Throwable {
        MyThrowsInterceptor interceptor = new MyThrowsInterceptor();
        AspectImpl aspect = new AspectImpl((MethodInterceptor)interceptor);
        AopProxy aopProxy = new AopProxy(ThrowerImpl.class, new Aspect[]{aspect});
        Thrower proxy = (Thrower)aopProxy.create();
        ThrowsInterceptorTest.assertEquals((String)"1", (Object)RuntimeException.class.getName(), (Object)proxy.throwRuntimeException());
        try {
            proxy.throwThrowable();
            ThrowsInterceptorTest.fail((String)"2");
        }
        catch (Throwable t) {
            ThrowsInterceptorTest.assertEquals((String)"1", (String)"hoge", (String)t.getMessage());
        }
    }

    public void testHandleThrowable2() throws Throwable {
        MyThrowsInterceptor2 interceptor = new MyThrowsInterceptor2();
        AspectImpl aspect = new AspectImpl((MethodInterceptor)interceptor);
        AopProxy aopProxy = new AopProxy(ThrowerImpl.class, new Aspect[]{aspect});
        Thrower proxy = (Thrower)aopProxy.create();
        try {
            proxy.throwException();
            ThrowsInterceptorTest.fail((String)"1");
        }
        catch (Exception ex) {
            ThrowsInterceptorTest.assertEquals((String)"1", (String)"hoge", (String)ex.getMessage());
        }
    }

    public void testHandleThrowable3() throws Throwable {
        MyThrowsInterceptor3 interceptor = new MyThrowsInterceptor3();
        AspectImpl aspect = new AspectImpl((MethodInterceptor)interceptor);
        AopProxy aopProxy = new AopProxy(ThrowerImpl.class, new Aspect[]{aspect});
        Thrower proxy = (Thrower)aopProxy.create();
        ThrowsInterceptorTest.assertEquals((String)"1", (Object)"aaa", (Object)proxy.throwException());
    }

    public void testHandleThrowable4() throws Throwable {
        try {
            new MyThrowsInterceptor4();
            ThrowsInterceptorTest.fail((String)"1");
        }
        catch (MethodNotFoundRuntimeException ex) {
            System.out.println((Object)ex);
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public class MyThrowsInterceptor4
    extends ThrowsInterceptor {
        private static final long serialVersionUID = 2583097886643107941L;
    }

    public class MyThrowsInterceptor3
    extends ThrowsInterceptor {
        private static final long serialVersionUID = -5725852748409700279L;

        public String handleThrowable(Exception ex, MethodInvocation invocation) throws Throwable {
            return (String)invocation.proceed();
        }
    }

    public class MyThrowsInterceptor2
    extends ThrowsInterceptor {
        private static final long serialVersionUID = -2523692002595965341L;

        public String handleThrowable(Exception ex, MethodInvocation invocation) throws Throwable {
            System.out.println("handleThrowable");
            throw ex;
        }
    }

    public class MyThrowsInterceptor
    extends ThrowsInterceptor {
        private static final long serialVersionUID = 850322067660303954L;

        public String handleThrowable(Exception ex, MethodInvocation invocation) {
            return ex.getClass().getName();
        }
    }

    public static class ThrowerImpl
    implements Thrower {
        private int num_;

        public Object throwThrowable() throws Throwable {
            throw new Throwable("hoge");
        }

        public Object throwException() throws Throwable {
            if (this.num_ == 0) {
                ++this.num_;
                throw new Exception("hoge");
            }
            return "aaa";
        }

        public Object throwRuntimeException() throws Throwable {
            throw new RuntimeException("hoge");
        }
    }

    public static interface Thrower {
        public Object throwThrowable() throws Throwable;

        public Object throwException() throws Throwable;

        public Object throwRuntimeException() throws Throwable;
    }
}

