/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.seasar.framework.aop.interceptors.PrototypeDelegateInterceptor;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.deployer.InstanceDefFactory;
import org.seasar.framework.container.impl.ComponentDefImpl;
import org.seasar.framework.container.impl.S2ContainerImpl;

public class PrototypeDelegateInterceptorTest
extends TestCase {
    private static List list = new ArrayList();
    private S2Container container;

    public void setUp() {
        list.clear();
        S2ContainerImpl containerImpl = new S2ContainerImpl();
        ComponentDefImpl singleton = new ComponentDefImpl(Target.class, "singleton");
        containerImpl.register((ComponentDef)singleton);
        ComponentDefImpl prototype = new ComponentDefImpl(Target.class, "prototype");
        prototype.setInstanceDef(InstanceDefFactory.PROTOTYPE);
        containerImpl.register((ComponentDef)prototype);
        containerImpl.init();
        this.container = containerImpl;
    }

    public void testSingleton() throws Exception {
        PrototypeDelegateInterceptor pdi = new PrototypeDelegateInterceptor(this.container);
        pdi.setTargetName("singleton");
        Hello proxy = (Hello)pdi.createProxy(Hello.class);
        proxy.foo();
        proxy.foo();
        PrototypeDelegateInterceptorTest.assertEquals((String)"1", (int)2, (int)list.size());
        PrototypeDelegateInterceptorTest.assertSame((String)"2", list.get(0), list.get(1));
    }

    public void testPrototype() throws Exception {
        PrototypeDelegateInterceptor pdi = new PrototypeDelegateInterceptor(this.container);
        pdi.setTargetName("prototype");
        Hello proxy = (Hello)pdi.createProxy(Hello.class);
        proxy.foo();
        proxy.foo();
        PrototypeDelegateInterceptorTest.assertEquals((String)"1", (int)2, (int)list.size());
        PrototypeDelegateInterceptorTest.assertNotSame((String)"2", list.get(0), list.get(1));
    }

    public void testMethodName() throws Exception {
        PrototypeDelegateInterceptor pdi = new PrototypeDelegateInterceptor(this.container);
        pdi.setTargetName("singleton");
        pdi.addMethodNameMap("bar", "foo");
        Hello proxy = (Hello)pdi.createProxy(Hello.class);
        proxy.bar();
        PrototypeDelegateInterceptorTest.assertEquals((String)"1", (int)1, (int)list.size());
    }

    public static class Target {
        public void foo() {
            list.add(this);
        }
    }

    public static interface Hello {
        public void foo();

        public void bar();
    }
}

