/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.interceptors;

import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.unit.S2FrameworkTestCase;

public class InterceptorChainTest
extends S2FrameworkTestCase {
    public void setUp() {
        this.include("InterceptorChainTest.dicon");
    }

    public void test() {
        Counter counter = (Counter)this.getComponent(Counter.class);
        InterceptorChainTest.assertEquals((int)0, (int)counter.getCount());
        Foo foo = (Foo)this.getComponent(Foo.class);
        foo.foo();
        InterceptorChainTest.assertEquals((int)5, (int)counter.getCount());
    }

    public static class CountInterceptor
    extends AbstractInterceptor {
        private static final long serialVersionUID = 4339376526738638703L;
        private int id_;
        private Counter counter_;

        public CountInterceptor(int id) {
            this.id_ = id;
        }

        public void setCounter(Counter counter) {
            this.counter_ = counter;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            this.counter_.increase();
            System.out.println("before(" + this.id_ + "):" + this.counter_.getCount());
            Object ret = invocation.proceed();
            System.out.println("after:" + this.id_);
            return ret;
        }
    }

    public static class CounterImpl
    implements Counter {
        private int count_;

        public int getCount() {
            return this.count_;
        }

        public void increase() {
            ++this.count_;
        }
    }

    public static interface Counter {
        public int getCount();

        public void increase();
    }

    public static class Foo {
        public void foo() {
        }
    }
}

