/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.eventusermodel;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.eventusermodel.HSSFUserException;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFactory;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class HSSFEventFactory {
    public void processWorkbookEvents(HSSFRequest req, POIFSFileSystem fs) throws IOException {
        DocumentInputStream in = fs.createDocumentInputStream("Workbook");
        this.processEvents(req, in);
    }

    public short abortableProcessWorkbookEvents(HSSFRequest req, POIFSFileSystem fs) throws IOException, HSSFUserException {
        DocumentInputStream in = fs.createDocumentInputStream("Workbook");
        return this.abortableProcessEvents(req, in);
    }

    public void processEvents(HSSFRequest req, InputStream in) throws IOException {
        try {
            this.genericProcessEvents(req, new RecordInputStream(in));
        }
        catch (HSSFUserException hSSFUserException) {
            // empty catch block
        }
    }

    public short abortableProcessEvents(HSSFRequest req, InputStream in) throws IOException, HSSFUserException {
        return this.genericProcessEvents(req, new RecordInputStream(in));
    }

    protected short genericProcessEvents(HSSFRequest req, RecordInputStream in) throws IOException, HSSFUserException {
        short userCode;
        block6: {
            userCode = 0;
            short sid = 0;
            Record rec = null;
            while (in.hasNextRecord()) {
                in.nextRecord();
                sid = in.getSid();
                if (sid == 0) break;
                if (rec != null && sid != 60 && (userCode = req.processRecord(rec)) != 0) break block6;
                if (sid != 60) {
                    Record[] recs = RecordFactory.createRecord(in);
                    if (recs.length > 1) {
                        for (int k = 0; k < recs.length - 1; ++k) {
                            userCode = req.processRecord(recs[k]);
                            if (userCode == 0) {
                                continue;
                            }
                            break block6;
                        }
                    }
                    rec = recs[recs.length - 1];
                    continue;
                }
                throw new RecordFormatException("Records should handle ContinueRecord internally. Should not see this exception");
            }
            if (rec == null || (userCode = req.processRecord(rec)) == 0) {
                // empty if block
            }
        }
        return userCode;
    }
}

