/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.FObjMixed;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.Status;
import org.apache.fop.layout.AccessibilityProps;
import org.apache.fop.layout.Area;
import org.apache.fop.layout.AuralProps;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.layout.BlockArea;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.HyphenationProps;
import org.apache.fop.layout.MarginProps;
import org.apache.fop.layout.RelativePositionProps;

public class Block
extends FObjMixed {
    int align;
    int alignLast;
    int breakAfter;
    int lineHeight;
    int startIndent;
    int endIndent;
    int spaceBefore;
    int spaceAfter;
    int textIndent;
    int keepWithNext;
    int areaHeight = 0;
    int contentWidth = 0;
    int infLoopThreshhold = 50;
    String id;
    int span = this.properties.get("span").getEnum();
    boolean breakStatusBeforeChecked = false;
    boolean anythingLaidOut = false;
    int noLayoutCount = 0;

    public Block(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
        super(parent, propertyList, systemId, line, column);
    }

    public int getAreaHeight() {
        return this.areaHeight;
    }

    public int getContentWidth() {
        return this.contentWidth;
    }

    public String getName() {
        return "fo:block";
    }

    public int getSpan() {
        return this.span;
    }

    public int layout(Area area) throws FOPException {
        if (!this.breakStatusBeforeChecked) {
            this.breakStatusBeforeChecked = true;
            int breakBeforeStatus = this.propMgr.checkBreakBefore(area);
            if (breakBeforeStatus != 1) {
                return breakBeforeStatus;
            }
        }
        if (!this.anythingLaidOut) {
            ++this.noLayoutCount;
        }
        if (this.noLayoutCount > this.infLoopThreshhold) {
            throw new FOPException("No meaningful layout in block after many attempts.  Infinite loop is assumed.  Processing halted.", this.systemId, this.line, this.column);
        }
        if (this.marker == -1001) {
            return 1;
        }
        if (this.marker == -1000) {
            this.noLayoutCount = 0;
            AccessibilityProps mAccProps = this.propMgr.getAccessibilityProps();
            AuralProps mAurProps = this.propMgr.getAuralProps();
            BorderAndPadding bap = this.propMgr.getBorderAndPadding();
            BackgroundProps bProps = this.propMgr.getBackgroundProps();
            HyphenationProps mHyphProps = this.propMgr.getHyphenationProps();
            MarginProps mProps = this.propMgr.getMarginProps();
            RelativePositionProps mRelProps = this.propMgr.getRelativePositionProps();
            this.align = this.properties.get("text-align").getEnum();
            this.alignLast = this.properties.get("text-align-last").getEnum();
            this.breakAfter = this.properties.get("break-after").getEnum();
            this.lineHeight = this.properties.get("line-height").getLength().mvalue();
            this.startIndent = this.properties.get("start-indent").getLength().mvalue();
            this.endIndent = this.properties.get("end-indent").getLength().mvalue();
            this.spaceBefore = this.properties.get("space-before.optimum").getLength().mvalue();
            this.spaceAfter = this.properties.get("space-after.optimum").getLength().mvalue();
            this.textIndent = this.properties.get("text-indent").getLength().mvalue();
            this.keepWithNext = this.properties.get("keep-with-next").getEnum();
            this.id = this.properties.get("id").getString();
            if (area instanceof BlockArea) {
                area.end();
            }
            if (area.getIDReferences() != null) {
                try {
                    area.getIDReferences().createID(this.id);
                }
                catch (FOPException e) {
                    if (!e.isLocationSet()) {
                        e.setLocation(this.systemId, this.line, this.column);
                    }
                    throw e;
                }
            }
            this.marker = 0;
        }
        if (this.spaceBefore != 0 && this.marker == 0) {
            area.addDisplaySpace(this.spaceBefore);
        }
        if (this.anythingLaidOut) {
            this.textIndent = 0;
        }
        if (this.marker == 0 && area.getIDReferences() != null) {
            area.getIDReferences().configureID(this.id, area);
        }
        int spaceLeft = area.spaceLeft();
        BlockArea blockArea = new BlockArea(this.propMgr.getFontState(area.getFontInfo()), area.getAllocationWidth(), area.spaceLeft(), this.startIndent, this.endIndent, this.textIndent, this.align, this.alignLast, this.lineHeight);
        blockArea.setGeneratedBy(this);
        ++this.areasGenerated;
        if (this.areasGenerated == 1) {
            blockArea.isFirst(true);
        }
        blockArea.setParent(area);
        blockArea.setPage(area.getPage());
        blockArea.setBackground(this.propMgr.getBackgroundProps());
        blockArea.setBorderAndPadding(this.propMgr.getBorderAndPadding());
        blockArea.setHyphenation(this.propMgr.getHyphenationProps());
        blockArea.start();
        blockArea.setAbsoluteHeight(area.getAbsoluteHeight());
        blockArea.setIDReferences(area.getIDReferences());
        blockArea.setTableCellXOffset(area.getTableCellXOffset());
        int numChildren = this.children.size();
        int i = this.marker;
        while (i < numChildren) {
            FONode fo = (FONode)this.children.get(i);
            int status = fo.layout(blockArea);
            if (Status.isIncomplete(status)) {
                this.marker = i;
                if (status == 2) {
                    if (i == 0) {
                        this.anythingLaidOut = false;
                        return status;
                    }
                    area.addChild(blockArea);
                    area.setMaxHeight(area.getMaxHeight() - spaceLeft + blockArea.getMaxHeight());
                    area.increaseHeight(blockArea.getHeight());
                    this.anythingLaidOut = true;
                    return 3;
                }
                area.addChild(blockArea);
                area.setMaxHeight(area.getMaxHeight() - spaceLeft + blockArea.getMaxHeight());
                area.increaseHeight(blockArea.getHeight());
                this.anythingLaidOut = true;
                return status;
            }
            this.anythingLaidOut = true;
            ++i;
        }
        blockArea.end();
        blockArea.isLast(true);
        area.addChild(blockArea);
        area.setMaxHeight(area.getMaxHeight() - spaceLeft + blockArea.getMaxHeight());
        area.increaseHeight(blockArea.getHeight());
        if (this.spaceAfter != 0) {
            area.addDisplaySpace(this.spaceAfter);
        }
        if (area instanceof BlockArea) {
            area.start();
        }
        this.areaHeight = blockArea.getHeight();
        this.contentWidth = blockArea.getContentWidth();
        int breakAfterStatus = this.propMgr.checkBreakAfter(area);
        if (breakAfterStatus != 1) {
            this.marker = -1001;
            blockArea = null;
            return breakAfterStatus;
        }
        if (this.keepWithNext != 0) {
            return 8;
        }
        return 1;
    }

    public static FObj.Maker maker() {
        return new Maker();
    }

    public void resetMarker() {
        this.anythingLaidOut = false;
        super.resetMarker();
    }

    public static class Maker
    extends FObj.Maker {
        public FObj make(FObj parent, PropertyList propertyList, String systemId, int line, int column) throws FOPException {
            return new Block(parent, propertyList, systemId, line, column);
        }
    }
}

