/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class DocumentOutputStream
extends OutputStream {
    private OutputStream stream;
    private int limit;
    private int written;

    DocumentOutputStream(OutputStream stream, int limit) {
        this.stream = stream;
        this.limit = limit;
        this.written = 0;
    }

    public void write(int b) throws IOException {
        this.limitCheck(1);
        this.stream.write(b);
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.limitCheck(len);
        this.stream.write(b, off, len);
    }

    public void flush() throws IOException {
        this.stream.flush();
    }

    public void close() throws IOException {
    }

    void writeFiller(int totalLimit, byte fill) throws IOException {
        if (totalLimit > this.written) {
            byte[] filler = new byte[totalLimit - this.written];
            Arrays.fill(filler, fill);
            this.stream.write(filler);
        }
    }

    private void limitCheck(int toBeWritten) throws IOException {
        if (this.written + toBeWritten > this.limit) {
            throw new IOException("tried to write too much data");
        }
        this.written += toBeWritten;
    }
}

