/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.sql.SQLException;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;

public class DataPageBinary
extends DataPage {
    public DataPageBinary(DataHandler handler, byte[] data) {
        super(handler, data);
    }

    public void updateChecksum() {
        int x = this.handler.getChecksum(this.data, 0, this.pos - 2);
        this.data[this.pos - 2] = (byte)x;
    }

    public void check(int len) throws SQLException {
        int x = this.handler.getChecksum(this.data, 0, len - 2);
        if (this.data[len - 2] == (byte)x) {
            return;
        }
        this.handler.handleInvalidChecksum();
    }

    public int getFillerLength() {
        return 2;
    }

    public void writeByte(byte x) {
        this.data[this.pos++] = x;
    }

    public int readByte() {
        return this.data[this.pos++];
    }

    public void writeInt(int x) {
        byte[] buff = this.data;
        buff[this.pos++] = (byte)(x >> 24);
        buff[this.pos++] = (byte)(x >> 16);
        buff[this.pos++] = (byte)(x >> 8);
        buff[this.pos++] = (byte)x;
    }

    public void setInt(int pos, int x) {
        byte[] buff = this.data;
        buff[pos] = (byte)(x >> 24);
        buff[pos + 1] = (byte)(x >> 16);
        buff[pos + 2] = (byte)(x >> 8);
        buff[pos + 3] = (byte)x;
    }

    public int readInt() {
        byte[] buff = this.data;
        return (buff[this.pos++] << 24) + ((buff[this.pos++] & 0xFF) << 16) + ((buff[this.pos++] & 0xFF) << 8) + (buff[this.pos++] & 0xFF);
    }

    private static int getStringLenUTF8(String s) {
        int plus = 4;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= '\u0800') {
                plus += 2;
                continue;
            }
            if (c != '\u0000' && c < '\u0080') continue;
            ++plus;
        }
        return len + plus;
    }

    private void writeStringUTF8(String s) {
        int len = s.length();
        this.checkCapacity(len * 3 + 4);
        int p = this.pos;
        byte[] buff = this.data;
        buff[p++] = (byte)(len >> 24);
        buff[p++] = (byte)(len >> 16);
        buff[p++] = (byte)(len >> 8);
        buff[p++] = (byte)len;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c > '\u0000' && c < '\u0080') {
                buff[p++] = (byte)c;
                continue;
            }
            if (c >= '\u0800') {
                buff[p++] = (byte)(0xE0 | c >> 12);
                buff[p++] = (byte)(0x80 | c >> 6 & 0x3F);
                buff[p++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            buff[p++] = (byte)(0xC0 | c >> 6);
            buff[p++] = (byte)(0x80 | c & 0x3F);
        }
        this.pos = p;
    }

    private String readStringUTF8() {
        byte[] buff = this.data;
        int p = this.pos;
        int len = ((buff[p++] & 0xFF) << 24) + ((buff[p++] & 0xFF) << 16) + ((buff[p++] & 0xFF) << 8) + (buff[p++] & 0xFF);
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            int x;
            chars[i] = (x = buff[p++] & 0xFF) < 128 ? (char)x : (x >= 224 ? (char)(((x & 0xF) << 12) + ((buff[p++] & 0x3F) << 6) + (buff[p++] & 0x3F)) : (char)(((x & 0x1F) << 6) + (buff[p++] & 0x3F)));
        }
        this.pos = p;
        return new String(chars);
    }

    public void writeString(String s) {
        this.writeStringUTF8(s);
    }

    public String readString() {
        return this.readStringUTF8();
    }

    public int getIntLen() {
        return 4;
    }

    public int getLongLen(long x) {
        return 8;
    }

    public int getStringLen(String s) {
        return DataPageBinary.getStringLenUTF8(s);
    }

    public void fill(int len) {
        if (this.pos > len) {
            this.pos = len;
        }
        this.checkCapacity(len - this.pos);
        this.pos = len;
    }
}

