/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.awt.Rectangle;
import java.io.UnsupportedEncodingException;
import org.apache.fop.pdf.PDFAction;
import org.apache.fop.pdf.PDFObject;

public class PDFLink
extends PDFObject {
    float ulx;
    float uly;
    float brx;
    float bry;
    String color;
    PDFAction action;

    public PDFLink(int number, Rectangle r) {
        super(number);
        this.ulx = r.x;
        this.uly = r.y;
        this.brx = r.x + r.width;
        this.bry = r.y - r.height;
        this.color = "0 0 0";
    }

    public void setAction(PDFAction action) {
        this.action = action;
    }

    public byte[] toPDF() {
        String p = String.valueOf(this.number) + " " + this.generation + " obj\n" + "<< /Type /Annot\n" + "/Subtype /Link\n" + "/Rect [ " + this.ulx / 1000.0f + " " + this.uly / 1000.0f + " " + this.brx / 1000.0f + " " + this.bry / 1000.0f + " ]\n" + "/C [ " + this.color + " ]\n" + "/Border [ 0 0 0 ]\n" + "/A " + this.action.getAction() + "\n" + "/H /I\n>>\nendobj\n";
        try {
            return p.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return p.getBytes();
        }
    }
}

