/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueBoolean
extends Value {
    public static final int PRECISION = 1;
    private final Boolean value;
    private static final ValueBoolean TRUE = new ValueBoolean(true);
    private static final ValueBoolean FALSE = new ValueBoolean(false);

    private ValueBoolean(boolean value) {
        this.value = Boolean.valueOf("" + value);
    }

    public int getType() {
        return 1;
    }

    public String getSQL() {
        return this.getString();
    }

    public String getString() {
        return this.value != false ? "TRUE" : "FALSE";
    }

    public Value negate() throws SQLException {
        return this.value != false ? FALSE : TRUE;
    }

    public Boolean getBoolean() {
        return this.value;
    }

    protected int compareSecure(Value o, CompareMode mode) {
        boolean v2 = ((ValueBoolean)o).value;
        boolean v = this.value;
        return v == v2 ? 0 : (v ? 1 : -1);
    }

    public long getPrecision() {
        return 1L;
    }

    public int hashCode() {
        return this.value != false ? 1 : 0;
    }

    public Object getObject() {
        return this.value;
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setBoolean(parameterIndex, this.value);
    }

    public static ValueBoolean get(boolean b) {
        return b ? TRUE : FALSE;
    }

    public int getDisplaySize() {
        return "FALSE".length();
    }

    protected boolean isEqual(Value v) {
        return v instanceof ValueBoolean && this.value.booleanValue() == ((ValueBoolean)v).value.booleanValue();
    }
}

