/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementTablePermission;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;

public class StatementColumnPermission
extends StatementTablePermission {
    private FormatableBitSet columns;

    public StatementColumnPermission(UUID uUID, int n, FormatableBitSet formatableBitSet) {
        super(uUID, n);
        this.columns = formatableBitSet;
    }

    public FormatableBitSet getColumns() {
        return this.columns;
    }

    public boolean equals(Object object) {
        if (object instanceof StatementColumnPermission) {
            StatementColumnPermission statementColumnPermission = (StatementColumnPermission)object;
            if (!this.columns.equals(statementColumnPermission.columns)) {
                return false;
            }
            return super.equals(object);
        }
        return false;
    }

    public void check(LanguageConnectionContext languageConnectionContext, String string, boolean bl) throws StandardException {
        DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
        if (this.hasPermissionOnTable(dataDictionary, string, bl)) {
            return;
        }
        FormatableBitSet formatableBitSet = null;
        if (!bl) {
            formatableBitSet = this.addPermittedColumns(dataDictionary, false, "PUBLIC", formatableBitSet);
            formatableBitSet = this.addPermittedColumns(dataDictionary, false, string, formatableBitSet);
        }
        formatableBitSet = this.addPermittedColumns(dataDictionary, true, "PUBLIC", formatableBitSet);
        formatableBitSet = this.addPermittedColumns(dataDictionary, true, string, formatableBitSet);
        int n = this.columns.anySetBit();
        while (n >= 0) {
            if (formatableBitSet == null || !formatableBitSet.get(n)) {
                TableDescriptor tableDescriptor = this.getTableDescriptor(dataDictionary);
                ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(n + 1);
                if (columnDescriptor == null) {
                    throw StandardException.newException("4250E", "column");
                }
                throw StandardException.newException(bl ? "42503" : "42502", string, (Object)this.getPrivName(), (Object)columnDescriptor.getColumnName(), (Object)tableDescriptor.getSchemaName(), (Object)tableDescriptor.getName());
            }
            n = this.columns.anySetBit(n);
        }
    }

    private FormatableBitSet addPermittedColumns(DataDictionary dataDictionary, boolean bl, String string, FormatableBitSet formatableBitSet) throws StandardException {
        if (formatableBitSet != null && formatableBitSet.getNumBitsSet() == formatableBitSet.size()) {
            return formatableBitSet;
        }
        ColPermsDescriptor colPermsDescriptor = dataDictionary.getColumnPermissions(this.tableUUID, this.privType, false, string);
        if (colPermsDescriptor != null) {
            if (formatableBitSet == null) {
                return colPermsDescriptor.getColumns();
            }
            formatableBitSet.or(colPermsDescriptor.getColumns());
        }
        return formatableBitSet;
    }

    public PermissionsDescriptor getPermissionDescriptor(String string, DataDictionary dataDictionary) throws StandardException {
        if (this.oneAuthHasPermissionOnTable(dataDictionary, string, false)) {
            return dataDictionary.getTablePermissions(this.tableUUID, string);
        }
        if (this.oneAuthHasPermissionOnTable(dataDictionary, "PUBLIC", false)) {
            return dataDictionary.getTablePermissions(this.tableUUID, "PUBLIC");
        }
        ColPermsDescriptor colPermsDescriptor = dataDictionary.getColumnPermissions(this.tableUUID, this.privType, false, string);
        if (colPermsDescriptor != null && colPermsDescriptor.getColumns() != null) {
            FormatableBitSet formatableBitSet = colPermsDescriptor.getColumns();
            int n = this.columns.anySetBit();
            while (n >= 0) {
                if (formatableBitSet.get(n)) {
                    return colPermsDescriptor;
                }
                n = this.columns.anySetBit(n);
            }
        }
        return null;
    }

    public PermissionsDescriptor getPUBLIClevelColPermsDescriptor(String string, DataDictionary dataDictionary) throws StandardException {
        ColPermsDescriptor colPermsDescriptor = dataDictionary.getColumnPermissions(this.tableUUID, this.privType, false, string);
        FormatableBitSet formatableBitSet = colPermsDescriptor.getColumns();
        boolean bl = true;
        int n = this.columns.anySetBit();
        while (n >= 0 && bl) {
            if (!formatableBitSet.get(n)) {
                bl = false;
            }
            n = this.columns.anySetBit(n);
        }
        if (bl) {
            return null;
        }
        return dataDictionary.getColumnPermissions(this.tableUUID, this.privType, false, "PUBLIC");
    }
}

