/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.message.Message;
import org.h2.schema.Schema;

public class CreateSchema
extends DefineCommand {
    private String schemaName;
    private String authorization;
    private boolean ifNotExists;

    public CreateSchema(Session session) {
        super(session);
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database db = this.session.getDatabase();
        User user = db.getUser(this.authorization);
        user.checkAdmin();
        if (db.findSchema(this.schemaName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw Message.getSQLException(90078, this.schemaName);
        }
        int id = this.getObjectId(true, true);
        Schema schema = new Schema(db, id, this.schemaName, user, false);
        db.addDatabaseObject(this.session, schema);
        return 0;
    }

    public void setSchemaName(String name) {
        this.schemaName = name;
    }

    public void setAuthorization(String userName) {
        this.authorization = userName;
    }
}

