/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.assembler;

import java.lang.reflect.Constructor;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.assembler.AbstractConstructorAssembler;
import org.seasar.framework.container.util.BindingUtil;
import org.seasar.framework.util.ConstructorUtil;

public class AutoConstructorAssembler
extends AbstractConstructorAssembler {
    public AutoConstructorAssembler(ComponentDef componentDef) {
        super(componentDef);
    }

    protected Object doAssemble() {
        Constructor constructor = this.getSuitableConstructor();
        if (constructor == null) {
            return this.assembleDefault();
        }
        Object[] args = this.getArgs(constructor.getParameterTypes());
        return ConstructorUtil.newInstance(constructor, args);
    }

    protected Constructor getSuitableConstructor() {
        int argSize = -1;
        Constructor<?> constructor = null;
        Constructor<?>[] constructors = this.getComponentDef().getConcreteClass().getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            int tempArgSize = constructors[i].getParameterTypes().length;
            if (tempArgSize == 0) {
                return null;
            }
            if (tempArgSize <= argSize || !BindingUtil.isAutoBindable(constructors[i].getParameterTypes())) continue;
            constructor = constructors[i];
            argSize = tempArgSize;
        }
        return constructor;
    }
}

