/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.unit;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.aopalliance.intercept.MethodInterceptor;
import org.seasar.extension.unit.S2TestCase;
import org.seasar.framework.aop.Pointcut;
import org.seasar.framework.aop.interceptors.MockInterceptor;
import org.seasar.framework.container.AspectDef;
import org.seasar.framework.container.factory.AspectDefFactory;
import org.seasar.framework.env.Env;
import org.seasar.framework.exception.NoSuchMethodRuntimeException;
import org.seasar.framework.unit.EasyMockSupport;
import org.seasar.framework.unit.Expression;
import org.seasar.framework.unit.annotation.Mock;
import org.seasar.framework.unit.annotation.Mocks;
import org.seasar.framework.unit.impl.OgnlExpression;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class S2TigerTestCase
extends S2TestCase {
    protected EasyMockSupport easyMockSupport = new EasyMockSupport();

    public S2TigerTestCase() {
    }

    public S2TigerTestCase(String name) {
        super(name);
    }

    public void runBare() throws Throwable {
        this.easyMockSupport.clear();
        super.runBare();
    }

    protected void setUpForEachTestMethod() throws Throwable {
        super.setUpForEachTestMethod();
        this.applyMockInterceptor(this.getTargetMethod());
        this.easyMockSupport.bindMockFields((Object)this, this.getContainer());
    }

    protected void doRunTest() throws Throwable {
        boolean recorded = this.doRecord();
        if (recorded) {
            this.easyMockSupport.replay();
        }
        super.doRunTest();
        if (recorded) {
            this.easyMockSupport.verify();
            this.easyMockSupport.reset();
        }
    }

    protected boolean doRecord() {
        String targetName = this.getTargetName();
        if (!StringUtil.isEmpty((String)targetName)) {
            try {
                Method method = ClassUtil.getMethod(((Object)((Object)this)).getClass(), (String)("record" + targetName), null);
                MethodUtil.invoke((Method)method, (Object)((Object)this), null);
                return true;
            }
            catch (NoSuchMethodRuntimeException noSuchMethodRuntimeException) {
                // empty catch block
            }
        }
        return false;
    }

    protected void tearDownForEachTestMethod() throws Throwable {
        this.easyMockSupport.unbindMockFields((Object)this);
        super.tearDownForEachTestMethod();
    }

    protected <T> T createMock(Class<T> clazz) {
        return this.easyMockSupport.createMock(clazz);
    }

    protected <T> T createNiceMock(Class<T> clazz) {
        return this.easyMockSupport.createNiceMock(clazz);
    }

    protected <T> T createStrictMock(Class<T> clazz) {
        return this.easyMockSupport.createStrictMock(clazz);
    }

    protected void applyMockInterceptor(Method method) {
        Mock mock = method.getAnnotation(Mock.class);
        if (mock != null) {
            this.applyMockInterceptor(mock, method);
        } else {
            Mocks mocks = method.getAnnotation(Mocks.class);
            if (mocks != null) {
                for (Mock each : mocks.value()) {
                    this.applyMockInterceptor(each, method);
                }
            }
        }
    }

    protected void applyMockInterceptor(Mock mock, Method method) {
        Expression exp;
        MockInterceptor mi = new MockInterceptor();
        if (!StringUtil.isEmpty((String)mock.returnValue())) {
            exp = this.createExpression(mock.returnValue(), method);
            mi.setReturnValue(exp.evaluate());
        }
        if (!StringUtil.isEmpty((String)mock.throwable())) {
            exp = this.createExpression(mock.throwable(), method);
            Object result = exp.evaluate();
            mi.setThrowable((Throwable)Throwable.class.cast(result));
        }
        Pointcut pc = null;
        pc = StringUtil.isEmpty((String)mock.pointcut()) ? AspectDefFactory.createPointcut(mock.target()) : AspectDefFactory.createPointcut((String)mock.pointcut());
        Object componentKey = StringUtil.isEmpty((String)mock.targetName()) ? mock.target() : mock.targetName();
        AspectDef aspectDef = AspectDefFactory.createAspectDef((MethodInterceptor)mi, (Pointcut)pc);
        this.addAspecDef(componentKey, aspectDef);
    }

    protected Expression createExpression(String source, Method method) {
        HashMap<String, Object> ctx = CollectionsUtil.newHashMap();
        ctx.put("ENV", Env.getValue());
        ctx.put("method", method);
        return new OgnlExpression(source, (Object)this, ctx);
    }

    protected void addAspecDef(Object componentKey, AspectDef aspectDef) {
        this.getContainer().getComponentDef(componentKey).addAspectDef(0, aspectDef);
    }

    protected abstract class Subsequence {
        protected Subsequence() {
        }

        public void doTest() throws Exception {
            this.record();
            S2TigerTestCase.this.easyMockSupport.replay();
            this.replay();
            S2TigerTestCase.this.easyMockSupport.verify();
            S2TigerTestCase.this.easyMockSupport.reset();
        }

        protected abstract void replay() throws Exception;

        protected void record() throws Exception {
        }
    }
}

