/*
 * Decompiled with CFR 0.152.
 */
package org.easymock;

import org.easymock.ArgumentsMatcher;

public abstract class AbstractMatcher
implements ArgumentsMatcher {
    protected boolean argumentMatches(Object expected, Object actual) {
        return expected.equals(actual);
    }

    protected String argumentToString(Object argument) {
        if (argument instanceof String) {
            return "\"" + argument + "\"";
        }
        return "" + argument;
    }

    public boolean matches(Object[] expected, Object[] actual) {
        if (expected == actual) {
            return true;
        }
        if (expected == null || actual == null) {
            return false;
        }
        if (expected.length != actual.length) {
            return false;
        }
        for (int i = 0; i < expected.length; ++i) {
            Object expectedObject = expected[i];
            Object actualObject = actual[i];
            if (expectedObject == null && actualObject == null) continue;
            if (expectedObject == null && actualObject != null) {
                return false;
            }
            if (expectedObject != null && actualObject == null) {
                return false;
            }
            if (this.argumentMatches(expectedObject, actualObject)) continue;
            return false;
        }
        return true;
    }

    public String toString(Object[] arguments) {
        if (arguments == null) {
            arguments = new Object[]{};
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < arguments.length; ++i) {
            if (i > 0) {
                result.append(", ");
            }
            result.append(this.argumentToString(arguments[i]));
        }
        return result.toString();
    }
}

