/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.jpa.impl;

import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.jpa.PersistenceClassTransformer;
import org.seasar.framework.jpa.PersistenceUnitConfiguration;
import org.seasar.framework.jpa.PersistenceUnitInfoRegistry;
import org.seasar.framework.jpa.impl.AbstractPersistenceUnitProvider;
import org.seasar.framework.jpa.impl.PersistenceUnitInfoImpl;
import org.seasar.framework.jpa.util.TransformClassLoader;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ClassTraversal;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ResourceTraversal;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.tiger.CollectionsUtil;
import org.seasar.framework.util.tiger.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerPersistenceUnitProvider
extends AbstractPersistenceUnitProvider {
    private static final Logger logger = Logger.getLogger(ContainerPersistenceUnitProvider.class);
    protected PersistenceUnitConfiguration persistenceUnitConfiguration;
    protected PersistenceUnitInfoRegistry persistenceUnitInfoRegistry;
    protected PersistenceClassTransformer persistenceClassTransformer;
    protected String providerClassName;
    protected Map<String, String> properties = CollectionsUtil.newHashMap();

    @Binding(bindingType=BindingType.MUST)
    public void setPersistenceUnitConfiguration(PersistenceUnitConfiguration persistenceUnitConfiguration) {
        this.persistenceUnitConfiguration = persistenceUnitConfiguration;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setPersistenceUnitInfoRegistry(PersistenceUnitInfoRegistry persistenceUnitInfoRegistry) {
        this.persistenceUnitInfoRegistry = persistenceUnitInfoRegistry;
    }

    @Binding(bindingType=BindingType.MUST)
    public void setPersistenceClassTransformer(PersistenceClassTransformer persistenceClassTransformer) {
        this.persistenceClassTransformer = persistenceClassTransformer;
    }

    @Binding(bindingType=BindingType.MAY)
    public void setProviderClassName(String providerClassName) {
        this.providerClassName = providerClassName;
    }

    @Binding(bindingType=BindingType.MAY)
    public void setProperties(Map<String, String> properties) {
        this.properties.putAll(properties);
    }

    @Override
    public EntityManagerFactory createEntityManagerFactory(String abstractUnitName, String concreteUnitName) {
        PersistenceUnitInfoImpl unitInfo = (PersistenceUnitInfoImpl)this.persistenceUnitInfoRegistry.getPersistenceUnitInfo(concreteUnitName);
        if (unitInfo == null) {
            throw new IllegalArgumentException(concreteUnitName);
        }
        this.overrideUnitInfo(unitInfo);
        this.addMappingFiles(abstractUnitName, unitInfo);
        this.addPersistenceClasses(abstractUnitName, unitInfo);
        PersistenceProvider provider = this.createPersistenceProvider(unitInfo);
        EntityManagerFactory emf = this.createEntityManagerFactory(provider, unitInfo);
        this.persistenceClassTransformer.transform(unitInfo);
        return emf;
    }

    protected void overrideUnitInfo(PersistenceUnitInfoImpl unitInfo) {
        if (!StringUtil.isEmpty((String)this.providerClassName)) {
            unitInfo.setPersistenceProviderClassName(this.providerClassName);
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            unitInfo.addProperties(entry.getKey(), entry.getValue());
        }
    }

    protected void addMappingFiles(String abstractUnitName, PersistenceUnitInfo unitInfo) {
        this.persistenceUnitConfiguration.detectMappingFiles(abstractUnitName, new MappingFileHandler(unitInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPersistenceClasses(String abstractUnitName, PersistenceUnitInfo unitInfo) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(unitInfo.getNewTempClassLoader());
        try {
            this.persistenceUnitConfiguration.detectPersistenceClasses(abstractUnitName, new PersistenceClassHandler(unitInfo));
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    protected PersistenceProvider createPersistenceProvider(PersistenceUnitInfo unitInfo) {
        String providerClassName = unitInfo.getPersistenceProviderClassName();
        Class providerClass = ReflectionUtil.forName(providerClassName);
        return (PersistenceProvider)ReflectionUtil.newInstance(providerClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EntityManagerFactory createEntityManagerFactory(PersistenceProvider provider, PersistenceUnitInfoImpl unitInfo) {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        TransformClassLoader transLoader = unitInfo.getTransformClassLoader();
        transLoader.registerPersistenceClassTransformer(this.persistenceClassTransformer);
        transLoader.registerPersistenceUnitInfo(unitInfo);
        Thread.currentThread().setContextClassLoader(transLoader);
        try {
            EntityManagerFactory entityManagerFactory = provider.createContainerEntityManagerFactory((PersistenceUnitInfo)unitInfo, null);
            return entityManagerFactory;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public static class PersistenceClassHandler
    implements ClassTraversal.ClassHandler {
        protected PersistenceUnitInfo unitInfo;
        protected final Set<String> packageNames = CollectionsUtil.newHashSet();

        public PersistenceClassHandler(PersistenceUnitInfo unitInfo) {
            this.unitInfo = unitInfo;
        }

        public void processClass(String packageName, String shortClassName) {
            String className = ClassUtil.concatName((String)packageName, (String)shortClassName);
            if (logger.isDebugEnabled()) {
                logger.log("DSSR0113", new Object[]{className, this.unitInfo.getPersistenceUnitName()});
            }
            this.unitInfo.getManagedClassNames().add(className);
            if (!this.packageNames.contains(packageName)) {
                this.addPackageInfo(packageName);
            }
        }

        protected void addPackageInfo(String packageName) {
            this.packageNames.add(packageName);
            String pkgInfoName = ClassUtil.concatName((String)packageName, (String)"package-info");
            Class pkgInfoClass = ReflectionUtil.forNameNoException(pkgInfoName);
            if (pkgInfoClass != null && pkgInfoClass.getPackage() != null) {
                this.unitInfo.getManagedClassNames().add(packageName);
            }
        }
    }

    public static class MappingFileHandler
    implements ResourceTraversal.ResourceHandler {
        protected PersistenceUnitInfo unitInfo;

        public MappingFileHandler(PersistenceUnitInfo unitInfo) {
            this.unitInfo = unitInfo;
        }

        public void processResource(String path, InputStream is) {
            if (logger.isDebugEnabled()) {
                logger.log("DSSR0112", new Object[]{path, this.unitInfo.getPersistenceUnitName()});
            }
            this.unitInfo.getMappingFileNames().add(path);
        }
    }
}

