/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.cubby.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seasar.cubby.action.ActionException;
import org.seasar.cubby.action.ActionResult;
import org.seasar.cubby.action.Forward;
import org.seasar.cubby.internal.util.LogMessages;
import org.seasar.cubby.validator.AbstractValidationRules;
import org.seasar.cubby.validator.FieldValidationRule;
import org.seasar.cubby.validator.ValidationPhase;
import org.seasar.cubby.validator.ValidationRule;
import org.seasar.cubby.validator.ValidationRules;
import org.seasar.cubby.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DefaultValidationRules
extends AbstractValidationRules {
    public static final ValidationPhase DATA_TYPE = new ValidationPhase();
    public static final ValidationPhase DATA_CONSTRAINT = new ValidationPhase();
    private static final List<ValidationRule> EMPTY_VALIDATION_RULES = Collections.emptyList();
    private final Map<ValidationPhase, List<ValidationRule>> phaseValidationRulesMap = new HashMap<ValidationPhase, List<ValidationRule>>();
    private final String resourceKeyPrefix;
    private static final List<ValidationPhase> VALIDATION_PHASES = Arrays.asList(DATA_TYPE, DATA_CONSTRAINT);

    public DefaultValidationRules() {
        this(null);
    }

    public DefaultValidationRules(String resourceKeyPrefix) {
        this.resourceKeyPrefix = resourceKeyPrefix;
        this.initialize(resourceKeyPrefix);
        this.initialize();
    }

    protected void initialize(String resourceKeyPrefix) {
    }

    protected void initialize() {
    }

    protected void add(ValidationPhase validationPhase, ValidationRule validationRule) {
        if (!this.phaseValidationRulesMap.containsKey(validationPhase)) {
            this.phaseValidationRulesMap.put(validationPhase, new ArrayList());
        }
        List<ValidationRule> validationRules = this.phaseValidationRulesMap.get(validationPhase);
        validationRules.add(validationRule);
    }

    protected ValidationPhase getDefaultValidationPhase() {
        return DATA_TYPE;
    }

    protected void add(ValidationRule validationRule) {
        this.add(this.getDefaultValidationPhase(), validationRule);
    }

    protected void add(String paramName, Validator ... validators) {
        this.add(paramName, paramName, validators);
    }

    protected void add(String paramName, String paramNameResourceKey, Validator ... validators) {
        this.add(this.getDefaultValidationPhase(), new FieldValidationRule(paramName, this.addResourceKeyPrefixTo(paramNameResourceKey), validators));
    }

    protected void addAll(ValidationRules validationRules) {
        for (ValidationPhase validationPhase : validationRules.getValidationPhases()) {
            Collection<ValidationRule> phaseValidationRules = validationRules.getPhaseValidationRules(validationPhase);
            for (ValidationRule validationRule : phaseValidationRules) {
                this.add(validationPhase, validationRule);
            }
        }
    }

    protected String addResourceKeyPrefixTo(String resourceKey) {
        if (this.resourceKeyPrefix == null) {
            return resourceKey;
        }
        return this.resourceKeyPrefix + resourceKey;
    }

    @Override
    public ActionResult fail(String errorPage) {
        if (errorPage == null || errorPage.length() == 0) {
            throw new ActionException(LogMessages.format("ECUB0106", new Object[0]));
        }
        return new Forward(errorPage);
    }

    public List<ValidationPhase> getValidationPhases() {
        return VALIDATION_PHASES;
    }

    @Override
    public Collection<ValidationRule> getPhaseValidationRules(ValidationPhase validationPhase) {
        Collection<ValidationRule> phaseValidationRules = this.phaseValidationRulesMap.containsKey(validationPhase) ? (Collection)this.phaseValidationRulesMap.get(validationPhase) : EMPTY_VALIDATION_RULES;
        return phaseValidationRules;
    }
}

